/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class CombinedXPath {
    private final XPathExpression targetExpr;
    private final XPathExpression parentExpr;

    CombinedXPath(XPath xPath, String parentPath, String targetRelativePath) {
        try {
            this.parentExpr = xPath.compile(parentPath);
            this.targetExpr = xPath.compile(parentPath + targetRelativePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    XPathExpression targetExpr() {
        return this.targetExpr;
    }

    XPathExpression parentExpr() {
        return this.parentExpr;
    }

    abstract void process(Document var1, Document var2) throws XPathExpressionException;

    static class DefaultedXPath
    extends CombinedXPath {
        DefaultedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            NodeList developerNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            if (developerNodes.getLength() > 0) {
                return;
            }
            NodeList generatedNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            Node developerParent = (Node)this.parentExpr().evaluate(developerDOM, XPathConstants.NODE);
            for (int i = 0; i < generatedNodes.getLength(); ++i) {
                developerParent.appendChild(developerDOM.adoptNode(generatedNodes.item(i)));
            }
        }
    }

    static class MergedXPath
    extends CombinedXPath {
        MergedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            Node developerParent;
            Node firstOriginalChild;
            NodeList developerNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            NodeList generatedNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            if (developerNodes.getLength() > 0) {
                firstOriginalChild = developerNodes.item(1);
                developerParent = firstOriginalChild.getParentNode();
            } else {
                firstOriginalChild = null;
                developerParent = (Node)this.parentExpr().evaluate(developerDOM, XPathConstants.NODE);
            }
            for (int i = 0; i < generatedNodes.getLength(); ++i) {
                Node generatedNode = generatedNodes.item(i);
                developerParent.insertBefore(developerDOM.adoptNode(generatedNode), firstOriginalChild);
            }
        }
    }

    static class OwnedXPath
    extends CombinedXPath {
        OwnedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            NodeList developerNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            NodeList generatedNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            for (int i = 0; i < generatedNodes.getLength(); ++i) {
                Node developerParent;
                Node generatedNode = generatedNodes.item(i);
                if (developerNodes.getLength() > 0) {
                    developerParent = developerNodes.item(1).getParentNode();
                    developerParent.replaceChild(developerNodes.item(i), developerDOM.adoptNode(generatedNode));
                    continue;
                }
                developerParent = (Node)this.parentExpr().evaluate(developerDOM, XPathConstants.NODE);
                developerParent.appendChild(developerDOM.adoptNode(generatedNode));
            }
        }
    }
}

