/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.glassfish.appclient.server.core.jws.DeveloperContentHandler;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XPathToDeveloperProvidedContentRefs<T extends Content> {
    private static final String STATIC_REFS_PROPERTY_NAME = "static.refs";
    private static final String DYNAMIC_REFS_PROPERTY_NAME = "dynamic.refs";
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();
    private static final XPath xPath = xPathFactory.newXPath();
    private static final Logger logger = LogDomains.getLogger(XPathToDeveloperProvidedContentRefs.class, (String)"javax.enterprise.system.container.appclient");
    private final XPathExpression xPathExpr;

    private XPathToDeveloperProvidedContentRefs(String path) {
        try {
            this.xPathExpr = xPath.compile(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static List<XPathToDeveloperProvidedContentRefs> parse(Properties p) {
        ArrayList<XPathToDeveloperProvidedContentRefs> result = new ArrayList<XPathToDeveloperProvidedContentRefs>();
        result.addAll(XPathToDeveloperProvidedContentRefs.parse(p, Type.STATIC));
        result.addAll(XPathToDeveloperProvidedContentRefs.parse(p, Type.DYNAMIC));
        return result;
    }

    private static List<XPathToDeveloperProvidedContentRefs> parse(Properties p, Type type) {
        ArrayList<XPathToDeveloperProvidedContentRefs> result = new ArrayList<XPathToDeveloperProvidedContentRefs>();
        String refs = p.getProperty(type.propertyName);
        for (String ref : refs.split(",")) {
            result.add(type == Type.STATIC ? new XPathToStaticContent(ref) : new XPathToDynamicContent(ref));
        }
        return result;
    }

    XPathExpression xPathExpr() {
        return this.xPathExpr;
    }

    abstract void addToContentIfInApp(DeveloperContentHandler var1, String var2, URI var3, String var4, ClassLoader var5, Map<String, StaticContent> var6, Map<String, DynamicContent> var7, URI var8) throws URISyntaxException, IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XPathToDynamicContent
    extends XPathToDeveloperProvidedContentRefs<DynamicContent> {
        XPathToDynamicContent(String path) {
            super(path);
        }

        @Override
        void addToContentIfInApp(DeveloperContentHandler dch, String referringDocument, URI codebase, String pathToContent, ClassLoader loader, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, URI appRootURI) throws URISyntaxException, IOException {
            int bytesRead;
            URI uriToContent = new URI(pathToContent);
            URI absURI = codebase.resolve(uriToContent);
            if (absURI.equals(uriToContent)) {
                return;
            }
            InputStream is = loader.getResourceAsStream(pathToContent);
            if (is == null) {
                return;
            }
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            is.close();
            dynamicContent.put(pathToContent, new SimpleDynamicContentImpl(baos.toString(), URLConnection.guessContentTypeFromName(pathToContent)));
            dch.addDeveloperContent(pathToContent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XPathToStaticContent
    extends XPathToDeveloperProvidedContentRefs<StaticContent> {
        XPathToStaticContent(String path) {
            super(path);
        }

        @Override
        void addToContentIfInApp(DeveloperContentHandler dch, String referringDocument, URI codebase, String pathToContent, ClassLoader loader, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, URI appRootURI) throws URISyntaxException {
            URI uriToContent = new URI(pathToContent);
            URI absURI = codebase.resolve(uriToContent);
            if (absURI.equals(uriToContent)) {
                return;
            }
            URI fileURI = appRootURI.resolve(pathToContent);
            File f = new File(fileURI);
            if (!f.exists() || !f.canRead()) {
                logger.log(Level.WARNING, "enterprise.deployment.appclient.jws.clientJNLPBadStaticContent", new Object[]{referringDocument, pathToContent});
            } else {
                staticContent.put(pathToContent, new FixedContent(f));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        STATIC("static.refs"),
        DYNAMIC("dynamic.refs");

        private String propertyName;

        private Type(String propName) {
            this.propertyName = propName;
        }
    }
}

