/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.util.Properties;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.NamingConventions;
import org.glassfish.appclient.server.core.jws.servedcontent.NestedClientTokenHelper;
import org.glassfish.appclient.server.core.jws.servedcontent.StandAloneClientTokenHelper;

public abstract class TokenHelper {
    private static final String AGENT_JAR = "gf-client.jar";
    private static final String DYN_PREFIX = "___dyn/";
    private Properties tokens;
    protected final AppClientDeployerHelper dHelper;

    public static TokenHelper newInstance(AppClientDeployerHelper dHelper) {
        TokenHelper tHelper = dHelper instanceof StandaloneAppClientDeployerHelper ? new StandAloneClientTokenHelper(dHelper) : new NestedClientTokenHelper(dHelper);
        tHelper.tokens = super.buildTokens();
        return tHelper;
    }

    public Properties tokens() {
        return this.tokens;
    }

    public Object setProperty(String propName, String propValue) {
        return this.tokens.setProperty(propName, propValue);
    }

    protected TokenHelper(AppClientDeployerHelper dHelper) {
        this.dHelper = dHelper;
    }

    public String appCodebasePath() {
        return NamingConventions.contextRootForAppAdapter(this.dHelper.appName());
    }

    public String systemContextRoot() {
        return "/___JWSappclient/___system";
    }

    public String agentJar() {
        return AGENT_JAR;
    }

    public String systemJNLP() {
        return NamingConventions.systemJNLPURI();
    }

    public abstract String appLibraryExtension();

    protected abstract String anchorSubpath();

    public String mainJNLP() {
        return this.dyn() + this.anchorSubpath() + "___main.jnlp";
    }

    public String clientJNLP() {
        return this.dyn() + this.anchorSubpath() + "___client.jnlp";
    }

    public String clientFacadeJNLP() {
        return this.dyn() + this.anchorSubpath() + "___clientFacade.jnlp";
    }

    public String dyn() {
        return DYN_PREFIX;
    }

    protected AppClientDeployerHelper dHelper() {
        return this.dHelper;
    }

    public String clientFacadeJARPath() {
        return this.anchorSubpath() + this.dHelper.clientName();
    }

    private Properties buildTokens() {
        Properties t = new Properties();
        t.setProperty("app.codebase.path", this.appCodebasePath());
        t.setProperty("main.jnlp.path", this.mainJNLP());
        t.setProperty("system.context.root", this.systemContextRoot());
        t.setProperty("agent.jar", this.agentJar());
        t.setProperty("system.jnlp", this.systemJNLP());
        t.setProperty("client.jnlp.path", this.clientJNLP());
        t.setProperty("app.library.extension", this.appLibraryExtension());
        t.setProperty("anchor.subpath", this.anchorSubpath());
        t.setProperty("dyn", this.dyn());
        t.setProperty("client.facade.jar.path", this.clientFacadeJARPath());
        return t;
    }
}

