/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACCClassLoader
extends URLClassLoader {
    private static ACCClassLoader instance = null;
    private ACCClassLoader shadow = null;
    private boolean shouldTransform = false;
    private final List<ClassFileTransformer> transformers = Collections.synchronizedList(new ArrayList());

    public static ACCClassLoader newInstance(ClassLoader parent, boolean shouldTransform) {
        if (instance != null) {
            throw new IllegalStateException("already set");
        }
        instance = new ACCClassLoader(parent, shouldTransform);
        return instance;
    }

    public static ACCClassLoader instance() {
        return instance;
    }

    public ACCClassLoader(ClassLoader parent) {
        super(ACCClassLoader.classPathToURLs(), parent.getParent());
        instance = this;
    }

    private static URL[] classPathToURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        ACCClassLoader.classPathToURLs(urls, System.getProperty("java.class.path"));
        String appcpath = System.getenv("APPCPATH");
        if (appcpath != null && appcpath.length() > 0) {
            ACCClassLoader.classPathToURLs(urls, appcpath);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void classPathToURLs(List<URL> urls, String classpath) {
        try {
            for (String s : classpath.split(File.pathSeparator)) {
                urls.add(new File(s).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public ACCClassLoader(ClassLoader parent, boolean shouldTransform) {
        super(new URL[0], parent);
        this.shouldTransform = shouldTransform;
    }

    public ACCClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public synchronized void appendURL(URL url) {
        this.addURL(url);
        if (this.shadow != null) {
            this.shadow.addURL(url);
        }
    }

    public void addTransformer(ClassFileTransformer xf) {
        this.transformers.add(xf);
    }

    public void setShouldTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
    }

    synchronized ACCClassLoader shadow() {
        if (this.shadow == null) {
            this.shadow = new ACCClassLoader(this.getURLs(), this.getParent());
        }
        return this.shadow;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.shouldTransform) {
            return super.findClass(name);
        }
        ACCClassLoader s = this.shadow();
        Class<?> c = s.findClassUnshadowed(name);
        return this.copyClass(c);
    }

    private Class<?> copyClass(Class c) throws ClassNotFoundException {
        String name = c.getName();
        ProtectionDomain pd = c.getProtectionDomain();
        byte[] bytecode = this.readByteCode(name);
        for (ClassFileTransformer xf : this.transformers) {
            try {
                bytecode = xf.transform(this, name, null, pd, bytecode);
            }
            catch (IllegalClassFormatException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, pd);
    }

    private Class<?> findClassUnshadowed(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private byte[] readByteCode(String className) throws ClassNotFoundException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = this.getResourceAsStream(resourceName);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8196];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
    }
}

