/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.appclient;

import com.sun.enterprise.security.J2EESecurityManager;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.appclient.integration.AppClientSecurityInfo;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Security;
import org.glassfish.appclient.client.acc.config.Ssl;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AppClientSecurityInfoImpl
implements AppClientSecurityInfo {
    private static Logger _logger = null;
    private static final String DEFAULT_PARSER_CLASS = "com.sun.enterprise.security.appclient.ConfigXMLParser";
    private CallbackHandler callbackHandler;
    private AppClientSecurityInfo.CredentialType appclientCredentialType;
    boolean isJWS;
    private List<TargetServer> targetServers;
    private List<MessageSecurityConfig> msgSecConfigs;
    @Inject
    protected SSLUtils sslUtils;
    @Inject
    private SecurityServicesUtil secServUtil;
    @Inject
    private Util util;
    @Inject
    private IIOPSSLUtil appClientSSLUtil;

    @Override
    public void initializeSecurity(List<TargetServer> tServers, List<MessageSecurityConfig> configs, CallbackHandler handler, AppClientSecurityInfo.CredentialType credType, String username, String password, boolean isJWS) {
        this.isJWS = isJWS;
        this.appclientCredentialType = credType;
        this.callbackHandler = handler;
        this.targetServers = tServers;
        this.msgSecConfigs = configs;
        SecurityManager secMgr = System.getSecurityManager();
        if (!isJWS && secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
            J2EESecurityManager mgr = new J2EESecurityManager();
            System.setSecurityManager((SecurityManager)mgr);
        }
        if (_logger.isLoggable(Level.FINE)) {
            if (secMgr != null) {
                _logger.fine("acc.secmgron");
            } else {
                _logger.fine("acc.secmgroff");
            }
        }
        System.setProperty("config.parser", DEFAULT_PARSER_CLASS);
        this.util.setAppClientMsgSecConfigs(this.msgSecConfigs);
        try {
            String defaultFactory = java.security.Security.getProperty("authconfigprovider.factory");
            if (defaultFactory == null) {
                java.security.Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "main.jmac_default_factory");
        }
        this.setSSLData(this.getTargetServers());
        if (username != null || password != null) {
            UsernamePasswordStore.set((String)username, (String)password);
        }
        this.secServUtil.setCallbackHandler(this.callbackHandler);
        this.util.setCallbackHandler(this.callbackHandler);
    }

    @Override
    public int getCredentialEncoding(AppClientSecurityInfo.CredentialType type) {
        switch (type) {
            case USERNAME_PASSWORD: {
                return 1;
            }
            case CERTIFICATE: {
                return 2;
            }
            case ALL: {
                return 3;
            }
        }
        throw new RuntimeException("Unknown CredentialType");
    }

    @Override
    public Subject doClientLogin(AppClientSecurityInfo.CredentialType credType) {
        return LoginContextDriver.doClientLogin((int)this.getCredentialEncoding(credType), (CallbackHandler)this.callbackHandler);
    }

    private AppClientSSL convert(Ssl ssl) {
        AppClientSSL appSSL = new AppClientSSL();
        appSSL.setCertNickname(ssl.getCertNickname());
        appSSL.setSsl2Ciphers(ssl.getSsl2Ciphers());
        appSSL.setSsl2Enabled(ssl.isSsl2Enabled());
        appSSL.setSsl3Enabled(ssl.isSsl3Enabled());
        appSSL.setSsl3TlsCiphers(ssl.getSsl3TlsCiphers());
        appSSL.setTlsEnabled(ssl.isTlsEnabled());
        appSSL.setTlsRollbackEnabled(ssl.isTlsRollbackEnabled());
        return appSSL;
    }

    private void setSSLData(List<TargetServer> tServers) {
        try {
            TargetServer tServer = tServers.get(0);
            Security security = tServer.getSecurity();
            if (security == null) {
                _logger.fine("No Security input set in ClientContainer.xml");
                return;
            }
            Ssl ssl = security.getSsl();
            if (ssl == null) {
                _logger.fine("No SSL input set in ClientContainer.xml");
                return;
            }
            this.sslUtils.setAppclientSsl(this.convert(ssl));
            this.appClientSSLUtil.setAppClientSSL((Object)this.convert(ssl));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<TargetServer> getTargetServers() {
        return this.targetServers;
    }

    public List<MessageSecurityConfig> getMsgSecConfigs() {
        return this.msgSecConfigs;
    }

    static {
        _logger = LogDomains.getLogger(AppClientSecurityInfoImpl.class, (String)"javax.enterprise.system.core.security");
    }
}

