/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.naming.ClientNamingConfigurator;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.AppClientContainer;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.config.AuthRealm;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Property;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.appclient.client.acc.config.util.XML;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientContainerBuilder
implements AppClientContainer.Builder {
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(AppClientContainerBuilder.class);
    private TargetServer[] targetServers;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private AuthRealm authRealm = null;
    private ACCClassLoader classLoader = (ACCClassLoader)Thread.currentThread().getContextClassLoader();
    private ClientCredential clientCredential = null;
    private boolean sendPassword = true;
    private final List<MessageSecurityConfig> messageSecurityConfigs = new ArrayList<MessageSecurityConfig>();
    private Properties containerProperties = null;

    AppClientContainerBuilder() {
    }

    AppClientContainerBuilder(TargetServer[] targetServers) {
        this.targetServers = targetServers;
    }

    public AppClientContainer newContainer(Class mainClass, CallbackHandler callerSpecifiedCallbackHandler) throws Exception {
        this.prepareHabitatAndNaming();
        Launchable client = Launchable.LaunchableUtil.newLaunchable(ACCModulesManager.getHabitat(), mainClass);
        AppClientContainer container = this.createContainer(client, callerSpecifiedCallbackHandler, false);
        return container;
    }

    @Override
    public AppClientContainer newContainer(Class mainClass) throws Exception {
        return this.newContainer(mainClass, null);
    }

    @Override
    public AppClientContainer newContainer(URI clientURI, CallbackHandler callerSpecifiedCallbackHandler, String callerSpecifiedMainClassName, String callerSpecifiedAppClientName) throws Exception, UserError {
        return this.newContainer(clientURI, callerSpecifiedCallbackHandler, callerSpecifiedMainClassName, callerSpecifiedAppClientName, false);
    }

    @Override
    public AppClientContainer newContainer(URI clientURI, CallbackHandler callerSpecifiedCallbackHandler, String callerSpecifiedMainClassName, String callerSpecifiedAppClientName, boolean isTextAuth) throws Exception, UserError {
        this.prepareHabitatAndNaming();
        Launchable client = Launchable.LaunchableUtil.newLaunchable(clientURI, callerSpecifiedMainClassName, callerSpecifiedAppClientName, ACCModulesManager.getHabitat());
        AppClientContainer container = this.createContainer(client, callerSpecifiedCallbackHandler, isTextAuth);
        return container;
    }

    @Override
    public AppClientContainer newContainer(URI clientURI) throws Exception, UserError {
        return this.newContainer(clientURI, null, null, null);
    }

    private AppClientContainer createContainer(Launchable client, CallbackHandler callerSuppliedCallbackHandler, boolean isTextAuth) throws BootException, BootException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InjectionException, IOException, SAXParseException {
        AppClientContainer container = ACCModulesManager.getComponent(AppClientContainer.class);
        container.setClient(client);
        container.setBuilder(this);
        CallbackHandler callbackHandler = callerSuppliedCallbackHandler != null ? callerSuppliedCallbackHandler : this.getCallbackHandlerFromDescriptor(client.getDescriptor(this.classLoader).getCallbackHandler());
        container.prepareSecurity(this.targetServers, this.messageSecurityConfigs, this.containerProperties, this.clientCredential, callbackHandler, this.classLoader, isTextAuth);
        return container;
    }

    private CallbackHandler getCallbackHandlerFromDescriptor(String callbackHandlerName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (callbackHandlerName != null && !callbackHandlerName.equals("")) {
            Class<?> callbackHandlerClass = Class.forName(callbackHandlerName, true, this.classLoader);
            return (CallbackHandler)callbackHandlerClass.newInstance();
        }
        return null;
    }

    private void prepareHabitatAndNaming() throws URISyntaxException {
        ACCModulesManager.initialize(Thread.currentThread().getContextClassLoader());
        ClientNamingConfigurator namingConfig = (ClientNamingConfigurator)ACCModulesManager.getHabitat().getByContract(ClientNamingConfigurator.class);
        if (this.targetServers.length > 0) {
            namingConfig.setDefaultHost(this.targetServers[0].getAddress());
            namingConfig.setDefaultPort(Integer.toString(this.targetServers[0].getPort()));
        }
    }

    @Override
    public AppClientContainerBuilder addMessageSecurityConfig(MessageSecurityConfig msConfig) {
        this.messageSecurityConfigs.add(msConfig);
        return this;
    }

    @Override
    public List<MessageSecurityConfig> getMessageSecurityConfig() {
        return this.messageSecurityConfigs;
    }

    @Override
    public AppClientContainerBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public AppClientContainerBuilder authRealm(String className) {
        this.authRealm = new AuthRealm(className);
        return this;
    }

    @Override
    public AuthRealm getAuthRealm() {
        return this.authRealm;
    }

    @Override
    public AppClientContainerBuilder clientCredentials(String user, char[] password) {
        return this.clientCredentials(user, password, null);
    }

    @Override
    public AppClientContainerBuilder clientCredentials(String user, char[] password, String realm) {
        ClientCredential cc = new ClientCredential(user, new XML.Password(password), realm);
        return this.clientCredentials(cc);
    }

    public AppClientContainerBuilder clientCredentials(ClientCredential cc) {
        this.clientCredential = cc;
        return this;
    }

    @Override
    public ClientCredential getClientCredential() {
        return this.clientCredential;
    }

    @Override
    public AppClientContainerBuilder containerProperties(Properties props) {
        this.containerProperties = props;
        return this;
    }

    @Override
    public AppClientContainerBuilder containerProperties(List<Property> props) {
        this.containerProperties = XML.toProperties(props);
        return this;
    }

    @Override
    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public AppClientContainerBuilder sendPassword(boolean sendPassword) {
        this.sendPassword = sendPassword;
        return this;
    }

    @Override
    public boolean getSendPassword() {
        return this.sendPassword;
    }

    @Override
    public TargetServer[] getTargetServers() {
        return this.targetServers;
    }
}

