/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.packageappclient;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public class PackageAppClient {
    private static final String OUTPUT_PREFIX = "appclient/";
    private static final String GLASSFISH_LIB = "glassfish/lib";
    private static final String GLASSFISH_BIN = "glassfish/bin";
    private static final String MODULES_ENDORSED_DIR = "glassfish/modules/endorsed";
    private static final String MQ_LIB = "mq/lib";
    private static final String DOMAIN_1_CONFIG = "glassfish/domains/domain1/config";
    private static final String INDENT = "  ";
    private static final String[] DIRS_TO_COPY = new String[]{"glassfish/lib/dtds", "glassfish/lib/schemas", "glassfish/lib/appclient"};
    private static final String LIB_ENDORSED_DIR = "glassfish/lib/endorsed";
    private static final String[] ENDORSED_DIRS_TO_COPY = new String[]{"glassfish/lib/endorsed", "glassfish/modules/endorsed"};
    private static final String DEFAULT_SUN_ACC_XML = "glassfish/domains/domain1/config/sun-acc.xml";
    private static final String IMQJMSRA_APP = "glassfish/lib/install/applications/jmsra/imqjmsra.jar";
    private static final String IMQ_JAR = "mq/lib/imq.jar";
    private static final String IMQADMIN_JAR = "mq/lib/imqadmin.jar";
    private static final String IMQUTIL_JAR = "mq/lib/imqutil.jar";
    private static final String FSCONTEXT_JAR = "mq/lib/fscontext.jar";
    private static final String WIN_SCRIPT = "glassfish/bin/appclient.bat";
    private static final String WIN_JS = "glassfish/bin/appclient.js";
    private static final String NONWIN_SCRIPT = "glassfish/bin/appclient";
    private static final String[] SINGLE_FILES_TO_COPY = new String[]{"glassfish/lib/install/applications/jmsra/imqjmsra.jar", "mq/lib/imq.jar", "mq/lib/imqadmin.jar", "mq/lib/imqutil.jar", "mq/lib/fscontext.jar", "glassfish/bin/appclient.bat", "glassfish/bin/appclient.js", "glassfish/bin/appclient"};
    private static final String DEFAULT_OUTPUT_PATH = "glassfish/lib/appclient.jar";
    private static final LocalStringsImpl strings = new LocalStringsImpl(PackageAppClient.class);
    private boolean isVerbose;

    public static void main(String[] args) {
        try {
            new PackageAppClient().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run(String[] args) throws URISyntaxException, IOException {
        this.isVerbose = this.isVerboseOutputLevel(args);
        File thisJarFile = this.findCurrentJarFile();
        File installDir = this.findInstallDir(thisJarFile);
        File modulesDir = new File(installDir.toURI().resolve("glassfish/modules/"));
        File outputFile = this.chooseOutputFile(installDir, args);
        if (outputFile.exists()) {
            if (!outputFile.delete()) {
                System.err.println(strings.get("errDel", new Object[]{outputFile.getAbsolutePath()}));
                System.exit(1);
            }
            System.out.println(strings.get("replacingFile", new Object[]{outputFile.getAbsolutePath()}));
        } else {
            System.out.println(strings.get("creatingFile", new Object[]{outputFile.getAbsolutePath()}));
        }
        File configFile = this.chooseConfigFile(installDir, args);
        if (!configFile.exists()) {
            System.err.println(strings.get("xmlNotFound", new Object[]{configFile.getAbsolutePath()}));
        }
        String[] classPathElements = this.getJarClassPath(thisJarFile).split(" ");
        JarOutputStream os = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        this.addFile(os, installDir.toURI(), thisJarFile.toURI(), outputFile, "");
        for (String classPathElement : classPathElements) {
            File classPathJAR = new File(modulesDir, classPathElement);
            this.addFile(os, installDir.toURI(), modulesDir.toURI().resolve(classPathJAR.toURI()), outputFile, "");
        }
        for (String dirToCopy : DIRS_TO_COPY) {
            this.addDir(os, installDir.toURI(), installDir.toURI().resolve(dirToCopy), outputFile, "");
        }
        for (String endorsedDirToCopy : ENDORSED_DIRS_TO_COPY) {
            this.addEndorsedFiles(os, installDir.toURI(), installDir.toURI().resolve(endorsedDirToCopy), outputFile);
        }
        for (String singleFileToCopy : SINGLE_FILES_TO_COPY) {
            this.addFile(os, installDir.toURI(), installDir.toURI().resolve(singleFileToCopy), outputFile, "");
        }
        this.addFile(os, installDir.toURI(), configFile.toURI(), outputFile, "");
        os.close();
    }

    private void addEndorsedFiles(JarOutputStream os, URI installDirURI, URI endorsedDirURI, File outputFile) throws IOException {
        this.addDir(os, installDirURI, endorsedDirURI, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") || pathname.isDirectory();
            }
        }, outputFile, "");
    }

    private void addFile(JarOutputStream os, URI installDirURI, URI absoluteURIToAdd, File outputFile, String indent) throws IOException {
        File fileToCopy = new File(absoluteURIToAdd);
        if (fileToCopy.equals(outputFile)) {
            return;
        }
        JarEntry entry = new JarEntry(OUTPUT_PREFIX + installDirURI.relativize(absoluteURIToAdd).toString());
        try {
            if (this.isVerbose) {
                System.err.println(indent + strings.get("addingFile", new Object[]{new File(absoluteURIToAdd).getAbsolutePath()}));
            }
            if (!new File(absoluteURIToAdd).exists()) {
                if (this.isVerbose) {
                    System.err.println(indent + strings.get("noFile", new Object[]{new File(absoluteURIToAdd).getAbsolutePath()}));
                }
                return;
            }
            os.putNextEntry(entry);
            if (new File(absoluteURIToAdd).isFile()) {
                this.copyFileToStream(os, absoluteURIToAdd);
            }
            os.closeEntry();
        }
        catch (ZipException e) {
            if (this.isVerbose) {
                System.err.println(indent + strings.get("zipExc", new Object[]{e.getLocalizedMessage()}));
            }
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
    }

    private void addDir(JarOutputStream os, URI installDirURI, URI absoluteDirURIToAdd, File outputFile, String indent) throws IOException {
        this.addDir(os, installDirURI, absoluteDirURIToAdd, null, outputFile, indent);
    }

    private void addDir(JarOutputStream os, URI installDirURI, URI absoluteDirURIToAdd, FileFilter fileFilter, File outputFile, String indent) throws IOException {
        File dirFile = new File(absoluteDirURIToAdd);
        File[] matchingFiles = dirFile.listFiles(fileFilter);
        if (matchingFiles == null) {
            return;
        }
        if (this.isVerbose) {
            System.err.println(indent + strings.get("addingDir", new Object[]{dirFile.getAbsolutePath()}));
        }
        for (File fileToAdd : matchingFiles) {
            if (fileToAdd.isFile()) {
                this.addFile(os, installDirURI, fileToAdd.toURI(), outputFile, indent + INDENT);
                continue;
            }
            if (!fileToAdd.isDirectory()) continue;
            this.addDir(os, installDirURI, fileToAdd.toURI(), outputFile, indent + INDENT);
        }
    }

    private void addDirEntry(JarOutputStream os, URI installDirURI, URI absoluteDirURIToAdd, File outputFile) {
    }

    private void copyFileToStream(OutputStream os, URI uriToCopy) throws FileNotFoundException, IOException {
        int bytesRead;
        File fileToCopy = new File(uriToCopy);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileToCopy));
        byte[] buffer = new byte[4096];
        while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        ((InputStream)is).close();
    }

    private File chooseOutputFile(File installDir, String[] args) {
        return this.chooseFile("-output", DEFAULT_OUTPUT_PATH, installDir, args);
    }

    private File chooseFile(String option, String defaultRelativeURI, File installDir, String[] args) {
        File result = null;
        for (int slot = 0; slot < args.length; ++slot) {
            if (!args[slot].equals(option)) continue;
            if (slot >= args.length - 1) {
                throw new IllegalArgumentException(option);
            }
            result = new File(args[slot + 1]);
            break;
        }
        if (result == null) {
            URI outputFileURI = installDir.toURI().resolve(defaultRelativeURI);
            result = new File(outputFileURI);
        }
        return result;
    }

    private File chooseConfigFile(File installDir, String[] args) {
        return this.chooseFile("-xml", DEFAULT_SUN_ACC_XML, installDir, args);
    }

    private File findInstallDir(File currentJarFile) throws URISyntaxException {
        return currentJarFile.getParentFile().getParentFile().getParentFile();
    }

    private boolean isVerboseOutputLevel(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-verbose")) continue;
            return true;
        }
        return false;
    }

    private File findCurrentJarFile() throws URISyntaxException {
        URI thisJarURI = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        URI thisJarFileBasedURI = thisJarURI.getScheme().startsWith("jar") ? URI.create("file:" + thisJarURI.getRawSchemeSpecificPart()) : thisJarURI;
        File result = new File(thisJarFileBasedURI);
        return result;
    }

    private String getJarClassPath(File currentJarFile) throws IOException {
        JarFile jf = new JarFile(currentJarFile);
        Manifest mf = jf.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        String classPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
        jf.close();
        return classPath;
    }
}

