/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import com.sun.enterprise.glassfish.bootstrap.ASMainStatic;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.glassfish.appclient.client.AppClientFacade;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.jws.boot.ErrorDisplayDialog;
import org.glassfish.appclient.client.jws.boot.LaunchSecurityHelper;

public class JWSAppClientContainerMain {
    public static final String SECURITY_CONFIG_PATH_PLACEHOLDER = "security.config.path";
    private static Logger logger = Logger.getLogger(JWSAppClientContainerMain.class.getName());
    private static final ResourceBundle rb = ResourceBundle.getBundle(JWSAppClientContainerMain.class.getPackage().getName().replaceAll("\\.", "/") + ".LocalStrings");

    public static void main(String[] args) {
        try {
            long now = System.currentTimeMillis();
            String agentArgsText = System.getProperty("agent.args");
            LaunchSecurityHelper.setPermissions();
            JWSAppClientContainerMain.insertMaskingLoader();
            AppClientFacade.prepareACC(agentArgsText, null);
            AppClientFacade.launch(args);
            logger.fine("JWSAppClientContainer finished after " + (System.currentTimeMillis() - now) + " ms");
        }
        catch (UserError ue) {
            ErrorDisplayDialog.showUserError(ue, rb);
        }
        catch (Throwable thr) {
            System.err.println(rb.getString("jwsacc.errorLaunch"));
            System.err.println(thr.toString());
            thr.printStackTrace();
            ErrorDisplayDialog.showErrors(thr, rb);
            System.exit(1);
        }
    }

    private static void insertMaskingLoader() throws IOException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String loaderConfig = System.getProperty("loader.config");
        StringReader sr = new StringReader(loaderConfig);
        Properties props = new Properties();
        props.load(sr);
        ClassLoader jwsLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader mcl = ASMainStatic.getMaskingClassLoader((ClassLoader)jwsLoader.getParent(), (Properties)props);
        Field jwsLoaderParentField = ClassLoader.class.getDeclaredField("parent");
        jwsLoaderParentField.setAccessible(true);
        jwsLoaderParentField.set(jwsLoader, mcl);
    }
}

