/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ACCStartupContext
extends StartupContext {
    private final long timeZero;
    private final Properties args = new Properties();

    public ACCStartupContext() {
        this.timeZero = System.currentTimeMillis();
        this.args.setProperty("com.sun.aas.installRoot", this.getRootDirectory().getAbsolutePath());
    }

    private File getRootDirectory() {
        URI jarURI = null;
        try {
            jarURI = ACCClassLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (jarURI.getScheme().startsWith("http")) {
            return new File(System.getProperty("user.home"));
        }
        File jarFile = new File(jarURI);
        File dirFile = jarFile.getParentFile().getParentFile();
        return dirFile;
    }

    public Properties getArguments() {
        return this.args;
    }

    public long getCreationTime() {
        return this.timeZero;
    }
}

