/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.util.LinkedList;
import java.util.Properties;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;

public class CachingDynamicContentImpl
extends Content.Adapter
implements DynamicContent {
    private static final int DEFAULT_MAX_INSTANCES = 4;
    private final String template;
    protected final String mimeType;
    private final LinkedList<DynamicContent.Instance> instances = new LinkedList();
    private final int maxInstances;

    public CachingDynamicContentImpl(String template, String mimeType) {
        this(template, mimeType, 4);
    }

    public CachingDynamicContentImpl(String template, String mimeType, int maxInstances) {
        this.template = template;
        this.mimeType = mimeType;
        this.maxInstances = maxInstances;
    }

    public DynamicContent.Instance getExistingInstance(Properties tokenValues) {
        return this.getOrCreateInstance(tokenValues, false);
    }

    public DynamicContent.Instance getOrCreateInstance(Properties tokenValues) {
        return this.getOrCreateInstance(tokenValues, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicContent.Instance getOrCreateInstance(Properties tokenValues, boolean createIfAbsent) {
        String textWithPlaceholdersReplaced = Util.replaceTokens(this.template, tokenValues);
        DynamicContent.InstanceAdapter result = null;
        LinkedList<DynamicContent.Instance> linkedList = this.instances;
        synchronized (linkedList) {
            for (DynamicContent.Instance i : this.instances) {
                if (!i.getText().equals(textWithPlaceholdersReplaced)) continue;
                return i;
            }
            if (createIfAbsent) {
                result = new DynamicContent.InstanceAdapter(textWithPlaceholdersReplaced);
                this.addInstance(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance(DynamicContent.Instance newInstance) {
        LinkedList<DynamicContent.Instance> linkedList = this.instances;
        synchronized (linkedList) {
            this.instances.addFirst(newInstance);
            if (this.instances.size() > this.maxInstances) {
                this.instances.removeLast();
            }
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    protected void clearInstances() {
        this.instances.clear();
    }

    public String toString() {
        return super.toString() + ", template=" + this.template + ", MIME type=" + this.mimeType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachingDynamicContentImpl other = (CachingDynamicContentImpl)obj;
        if (this.template == null ? other.template != null : !this.template.equals(other.template)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        return this.maxInstances == other.maxInstances;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.template != null ? this.template.hashCode() : 0);
        hash = 89 * hash + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        hash = 89 * hash + this.maxInstances;
        return hash;
    }
}

