/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.appclient.client.acc.UserError;

public class CLIBootstrap {
    private static final boolean isDebug = System.getenv("AS_DEBUG") != null;
    private static final String INPUT_ARGS = System.getenv("inputArgs");
    static final String ENV_VAR_PROP_PREFIX = "acc.";
    private static final String JAVA_NAME = File.separatorChar == '/' ? "java" : "java.exe";
    private static final String ACC_VALUED_OPTIONS_PATTERN = "-mainclass|-name|-xml|-configxml|-user|-password|-passwordfile|-targetserver";
    private static final String ACC_UNVALUED_OPTIONS_PATTERN = "-textauth|-noappinvoke|-usage|-help";
    private static final String JVM_VALUED_OPTIONS_PATTERN = "-classpath|-cp";
    private static final String INSTALL_ROOT_PROPERTY_EXPR = "-Dcom.sun.aas.installRoot=";
    private static final String SECURITY_POLICY_PROPERTY_EXPR = "-Djava.security.policy=";
    private static final String SECURITY_AUTH_LOGIN_CONFIG_PROPERTY_EXPR = "-Djava.security.auth.login.config=";
    private static final String SYSTEM_CLASS_LOADER_PROPERTY_EXPR = "-Djava.system.class.loader=org.glassfish.appclient.client.acc.agent.ACCAgentClassLoader";
    private static final String[] ENV_VARS = new String[]{"_AS_INSTALL", "APPCPATH", "VMARGS"};
    private static final String EXT_DIRS_INTRODUCER = "-Djava.ext.dirs";
    private static final String ENDORSED_DIRS_INTRODUCER = "-Djava.endorsed.dirs";
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(CLIBootstrap.class);
    private JavaInfo java;
    private GlassFishInfo gfInfo;
    private UserVMArgs userVMArgs;
    private CommandLineElement extDirs;
    private CommandLineElement endorsedDirs;
    private CommandLineElement accValuedOptions;
    private CommandLineElement accUnvaluedOptions;
    private CommandLineElement jvmPropertySettings;
    private CommandLineElement jvmValuedOptions;
    private CommandLineElement otherJVMOptions;
    private CommandLineElement arguments;
    private final AgentArgs agentArgs = new AgentArgs();
    private final JVMMainOption jvmMainSetting = new JVMMainOption();
    private final List<CommandLineElement> elements = new ArrayList<CommandLineElement>();

    public static void main(String[] args) {
        try {
            CLIBootstrap.envToProps();
            CLIBootstrap boot = new CLIBootstrap();
            if (INPUT_ARGS != null) {
                args = CLIBootstrap.convertInputArgsVariable(INPUT_ARGS);
            }
            String outputCommandLine = boot.run(args);
            if (isDebug) {
                System.err.println(outputCommandLine);
            }
            System.out.println(outputCommandLine);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
    }

    private static String[] convertInputArgsVariable(String inputArgs) {
        Pattern argPattern = Pattern.compile("\"([^\"]+)\"|([^\"\\s]+)");
        Matcher matcher = argPattern.matcher(inputArgs);
        ArrayList<String> argList = new ArrayList<String>();
        while (matcher.find()) {
            String arg = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            argList.add(arg);
            if (!isDebug) continue;
            System.err.println("Captured argument " + arg);
        }
        return argList.toArray(new String[argList.size()]);
    }

    private static void envToProps() {
        for (String envVar : ENV_VARS) {
            String value = System.getenv(envVar);
            if (value == null) continue;
            System.setProperty(ENV_VAR_PROP_PREFIX + envVar, value);
            if (!isDebug) continue;
            System.err.println(ENV_VAR_PROP_PREFIX + envVar + " set to " + value);
        }
    }

    CLIBootstrap() throws UserError {
        this.init();
    }

    private void init() throws UserError {
        this.java = this.initJava();
        this.gfInfo = new GlassFishInfo();
        this.userVMArgs = new UserVMArgs(System.getProperty("acc.VMARGS"));
        this.extDirs = new OverridableDefaultedPathBasedOption(EXT_DIRS_INTRODUCER, this.userVMArgs.evExtDirs, this.java.ext().getAbsolutePath(), this.gfInfo.extPaths());
        this.endorsedDirs = new OverridableDefaultedPathBasedOption(ENDORSED_DIRS_INTRODUCER, this.userVMArgs.evEndorsedDirs, this.java.endorsed().getAbsolutePath(), this.gfInfo.endorsedPaths());
        this.accValuedOptions = new ACCValuedOption(ACC_VALUED_OPTIONS_PATTERN);
        this.accUnvaluedOptions = new ACCUnvaluedOption(ACC_UNVALUED_OPTIONS_PATTERN);
        this.jvmPropertySettings = new JVMOption("-D.*", this.userVMArgs.evJVMPropertySettings);
        this.jvmValuedOptions = new JVMValuedOption(JVM_VALUED_OPTIONS_PATTERN, this.userVMArgs.evJVMValuedOptions);
        this.otherJVMOptions = new JVMOption("-.*", this.userVMArgs.evOtherJVMOptions);
        this.arguments = new CommandLineElement(".*");
        this.initCommandLineElements();
    }

    private void initCommandLineElements() {
        ArrayList<CommandLineElement> result = new ArrayList<CommandLineElement>();
        result.add(this.extDirs);
        result.add(this.endorsedDirs);
        result.add(this.accValuedOptions);
        result.add(this.accUnvaluedOptions);
        result.add(this.jvmValuedOptions);
        result.add(this.jvmPropertySettings);
        result.add(this.jvmMainSetting);
        result.add(this.otherJVMOptions);
        result.add(this.arguments);
        this.elements.addAll(result);
    }

    private static String quote(String s) {
        return '\"' + s + '\"';
    }

    private static String quoteSuppressTokenSubst(String s) {
        return OS.isWindows() ? CLIBootstrap.quote(s) : CLIBootstrap.quote(s.replace("$", "\\$"));
    }

    private void addProperties(StringBuilder command) {
        command.append(' ').append(INSTALL_ROOT_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.home().getAbsolutePath()));
        command.append(' ').append(SECURITY_POLICY_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.securityPolicy().getAbsolutePath()));
        command.append(' ').append(SYSTEM_CLASS_LOADER_PROPERTY_EXPR);
        command.append(' ').append(SECURITY_AUTH_LOGIN_CONFIG_PROPERTY_EXPR).append(CLIBootstrap.quote(this.gfInfo.loginConfig().getAbsolutePath()));
    }

    private String run(String[] args) throws UserError {
        int i;
        this.java = this.initJava();
        this.gfInfo = new GlassFishInfo();
        String[] augmentedArgs = new String[args.length + 2];
        augmentedArgs[0] = "-configxml";
        augmentedArgs[1] = this.gfInfo.configxml().getAbsolutePath();
        for (i = 0; i < args.length; ++i) {
            augmentedArgs[i + 2] = args[i];
        }
        i = 0;
        while (i < augmentedArgs.length) {
            boolean isMatched = false;
            for (CommandLineElement cle : this.elements) {
                isMatched = cle.matches(augmentedArgs[i]);
                if (!isMatched) continue;
                i = cle.processValue(augmentedArgs, i);
                break;
            }
            if (isMatched) continue;
            throw new UserError("arg " + i + " = " + augmentedArgs[i] + " not recognized");
        }
        StringBuilder command = new StringBuilder(CLIBootstrap.quote(this.java.javaExe.getAbsolutePath()));
        this.addProperties(command);
        this.jvmValuedOptions.format(command);
        this.jvmPropertySettings.format(command);
        this.otherJVMOptions.format(command);
        this.extDirs.format(command);
        this.endorsedDirs.format(command);
        if (!this.jvmMainSetting.isSet()) {
            this.accUnvaluedOptions.processValue(new String[]{"-usage"}, 0);
        }
        this.accUnvaluedOptions.format(command);
        this.accValuedOptions.format(command);
        this.addAgentOption(command);
        this.jvmMainSetting.format(command);
        this.arguments.format(command);
        return command.toString();
    }

    private void addAgentOption(StringBuilder command) {
        command.append(' ').append("-javaagent:").append(CLIBootstrap.quote(this.gfInfo.agentJarPath())).append(this.agentArgs.toString());
    }

    JavaInfo initJava() {
        return new JavaInfo();
    }

    class UserVMArgs {
        private CommandLineElement evExtDirs;
        private CommandLineElement evEndorsedDirs;
        private CommandLineElement evJVMPropertySettings;
        private CommandLineElement evJVMValuedOptions;
        private CommandLineElement evOtherJVMOptions;
        private final List<CommandLineElement> evElements = new ArrayList<CommandLineElement>();

        UserVMArgs(String vmargs) throws UserError {
            if (isDebug) {
                System.err.println("VMARGS = " + (vmargs == null ? "null" : vmargs));
            }
            this.evExtDirs = new OverridableDefaultedPathBasedOption(CLIBootstrap.EXT_DIRS_INTRODUCER, null, CLIBootstrap.this.java.ext().getAbsolutePath(), CLIBootstrap.this.gfInfo.extPaths());
            this.evEndorsedDirs = new OverridableDefaultedPathBasedOption(CLIBootstrap.ENDORSED_DIRS_INTRODUCER, null, CLIBootstrap.this.java.endorsed().getAbsolutePath(), CLIBootstrap.this.gfInfo.endorsedPaths());
            this.evJVMPropertySettings = new JVMOption("-D.*", null);
            this.evJVMValuedOptions = new JVMValuedOption(CLIBootstrap.JVM_VALUED_OPTIONS_PATTERN, null);
            this.evOtherJVMOptions = new JVMOption("-.*", null);
            this.initEVCommandLineElements();
            if (vmargs == null) {
                return;
            }
            this.processEVCommandLineElements(CLIBootstrap.convertInputArgsVariable(vmargs));
        }

        private void initEVCommandLineElements() {
            this.evElements.add(this.evExtDirs);
            this.evElements.add(this.evEndorsedDirs);
            this.evElements.add(this.evJVMPropertySettings);
            this.evElements.add(this.evJVMValuedOptions);
            this.evElements.add(this.evOtherJVMOptions);
        }

        private void processEVCommandLineElements(String[] envVarJVMArgs) throws UserError {
            int i = 0;
            while (i < envVarJVMArgs.length) {
                boolean isMatched = false;
                for (CommandLineElement cle : this.evElements) {
                    isMatched = cle.matches(envVarJVMArgs[i]);
                    if (!isMatched) continue;
                    i = cle.processValue(envVarJVMArgs, i);
                    break;
                }
                if (isMatched) continue;
                throw new UserError("arg " + i + " = " + envVarJVMArgs[i] + " not recognized");
            }
        }
    }

    class JavaInfo {
        protected File javaExe;
        protected File javaHome;

        private JavaInfo() {
            this.init();
        }

        protected void init() {
            this.javaHome = new File(System.getProperty("java.home"));
            this.javaExe = this.javaExe();
        }

        protected boolean isValid() {
            return this.javaExe != null && this.javaExe.canExecute();
        }

        protected File javaBinDir() {
            return new File(this.javaHome, "bin");
        }

        File javaExe() {
            return new File(this.javaBinDir(), JAVA_NAME);
        }

        File endorsed() {
            return new File(this.lib(), "endorsed");
        }

        File ext() {
            return new File(this.lib(), "ext");
        }

        File lib() {
            return new File(this.javaHome, "lib");
        }
    }

    class GlassFishInfo {
        private final File home;
        private final File modules;
        private final File lib;
        private final File libAppclient;

        GlassFishInfo() {
            String asInstallPath = System.getProperty("acc._AS_INSTALL");
            if (asInstallPath == null || asInstallPath.length() == 0) {
                throw new IllegalArgumentException("_AS_INSTALL == null");
            }
            this.home = new File(asInstallPath);
            this.modules = new File(this.home, "modules");
            this.lib = new File(this.home, "lib");
            this.libAppclient = new File(this.lib, "appclient");
        }

        File home() {
            return this.home;
        }

        File modules() {
            return this.modules;
        }

        File lib() {
            return this.lib;
        }

        File configxml() {
            return new File(new File(this.home, "domains/domain1/config"), "sun-acc.xml");
        }

        String[] endorsedPaths() {
            return new String[]{new File(this.lib, "endorsed").getAbsolutePath(), new File(this.modules, "endorsed").getAbsolutePath()};
        }

        String extPaths() {
            return new File(this.lib, "ext").getAbsolutePath();
        }

        String agentJarPath() {
            return new File(this.lib, "gf-client.jar").getAbsolutePath();
        }

        File securityPolicy() {
            return new File(this.libAppclient, "client.policy");
        }

        File loginConfig() {
            return new File(this.libAppclient, "appclientlogin.conf");
        }
    }

    private class OverridableDefaultedPathBasedOption
    extends JVMOption {
        private final String defaultValue;
        private final List<String> gfValues;
        private final String introducer;
        private boolean hasCommandLineValueAppeared;

        OverridableDefaultedPathBasedOption(String introducer, CommandLineElement settingsFromEnvVar, String defaultValue, String ... gfValues) {
            super(introducer + "=.*", null);
            this.hasCommandLineValueAppeared = false;
            if (settingsFromEnvVar != null) {
                this.values.addAll(settingsFromEnvVar.values);
            }
            this.introducer = introducer;
            this.defaultValue = defaultValue;
            this.gfValues = Arrays.asList(gfValues);
        }

        int processValue(String[] args, int slot) throws UserError {
            if (!this.hasCommandLineValueAppeared) {
                this.values.clear();
                this.hasCommandLineValueAppeared = true;
            }
            for (String pathElement : args[slot++].substring(this.introducer.length() + 1).split(File.pathSeparator)) {
                this.values.add(pathElement);
            }
            return slot;
        }

        StringBuilder format(StringBuilder commandLine) {
            ArrayList<String> combinedValues = new ArrayList<String>();
            if (this.values.isEmpty()) {
                combinedValues.addAll(this.gfValues);
                combinedValues.add(this.defaultValue);
            } else {
                combinedValues.addAll(this.values);
                combinedValues.addAll(this.gfValues);
            }
            commandLine.append(this.introducer).append("=");
            boolean needSep = false;
            for (String value : combinedValues) {
                if (needSep) {
                    commandLine.append(File.pathSeparatorChar);
                }
                commandLine.append(CLIBootstrap.quoteSuppressTokenSubst(value));
                needSep = true;
            }
            commandLine.append(' ');
            return commandLine;
        }
    }

    private class JVMMainOption
    extends CommandLineElement {
        private static final String JVM_MAIN_PATTERN = "-jar|-client|[^-][^\\s]*";
        private String introducer;

        JVMMainOption() {
            super(JVM_MAIN_PATTERN);
            this.introducer = null;
        }

        boolean isJarSetting() {
            return "-jar".equals(this.introducer);
        }

        boolean isClientSetting() {
            return "-client".equals(this.introducer);
        }

        boolean isClassSetting() {
            return !this.isJarSetting() && !this.isClientSetting() && this.isSet();
        }

        boolean isSet() {
            return !this.values.isEmpty();
        }

        boolean matches(String element) {
            return (!this.isSet() || this.isClientSetting() && element.equals("-client")) && super.matches(element);
        }

        int processValue(String[] args, int slot) throws UserError {
            this.values.clear();
            if (args[slot].charAt(0) == '-') {
                if (this.nextLooksOK(args, slot)) {
                    this.introducer = args[slot++];
                    int result = super.processValue(args, slot);
                    String path = (String)this.values.get(this.values.size() - 1);
                    File clientSpec = new File(path);
                    if (clientSpec.isDirectory()) {
                        CLIBootstrap.this.agentArgs.add("client=dir=" + CLIBootstrap.quoteSuppressTokenSubst(clientSpec.getAbsolutePath()));
                        this.introducer = "-jar";
                        this.values.set(this.values.size() - 1, CLIBootstrap.this.gfInfo.agentJarPath());
                    } else {
                        CLIBootstrap.this.agentArgs.add("client=jar=" + CLIBootstrap.quoteSuppressTokenSubst(path));
                        if (path.endsWith(".ear")) {
                            this.introducer = "-jar";
                            this.values.set(this.values.size() - 1, CLIBootstrap.this.gfInfo.agentJarPath());
                        }
                    }
                    return result;
                }
                throw new UserError("-jar or -client requires value but missing");
            }
            int result = super.processValue(args, slot);
            CLIBootstrap.this.agentArgs.add("client=class=" + (String)this.values.get(this.values.size() - 1));
            return result;
        }

        StringBuilder format(StringBuilder commandLine) {
            if (this.introducer != null) {
                super.format(commandLine, false, "-jar");
                return super.format(commandLine, true);
            }
            return super.format(commandLine, false);
        }

        private boolean nextLooksOK(String[] args, int slot) {
            return this.isNextArg(args, slot) && args[slot + 1].charAt(0) != '-';
        }
    }

    private class ACCValuedOption
    extends ValuedOption {
        ACCValuedOption(String patternString) {
            super(patternString);
        }

        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }

        int processValue(String[] args, int slot) throws UserError {
            int result = super.processValue(args, slot);
            ValuedOption.OptionValue newOptionValue = (ValuedOption.OptionValue)this.optValues.get(this.optValues.size() - 1);
            CLIBootstrap.this.agentArgs.addACCArg(newOptionValue.option);
            CLIBootstrap.this.agentArgs.addACCArg(CLIBootstrap.quoteSuppressTokenSubst(newOptionValue.value));
            return result;
        }

        StringBuilder format(StringBuilder commandLine) {
            return commandLine;
        }
    }

    private class JVMValuedOption
    extends ValuedOption {
        JVMValuedOption(String patternString, CommandLineElement vmargsJVMValuedOption) {
            super(patternString);
            if (vmargsJVMValuedOption != null) {
                this.values.addAll(vmargsJVMValuedOption.values);
            }
        }

        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }
    }

    private class ValuedOption
    extends Option {
        List<OptionValue> optValues;

        ValuedOption(String patternString) {
            super(patternString);
            this.optValues = new ArrayList<OptionValue>();
        }

        int processValue(String[] args, int slot) throws UserError {
            this.ensureNonOptionNextArg(args, slot);
            this.optValues.add(new OptionValue(args[slot++], args[slot++]));
            return slot;
        }

        StringBuilder format(StringBuilder commandLine) {
            for (OptionValue ov : this.optValues) {
                this.format(commandLine, false, ov.option);
                this.format(commandLine, true, ov.value);
            }
            return commandLine;
        }

        class OptionValue {
            private String option;
            private String value;

            OptionValue(String option, String value) {
                this.option = option;
                this.value = value;
            }
        }
    }

    private class ACCUnvaluedOption
    extends Option {
        ACCUnvaluedOption(String patternString) {
            super(patternString);
        }

        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isJarSetting() && super.matches(element);
        }

        int processValue(String[] args, int slot) throws UserError {
            int result = super.processValue(args, slot);
            CLIBootstrap.this.agentArgs.addACCArg((String)this.values.get(this.values.size() - 1));
            return result;
        }

        StringBuilder format(StringBuilder commandLine) {
            return commandLine;
        }
    }

    private class JVMOption
    extends Option {
        JVMOption(String patternString, CommandLineElement vmargsJVMOptionElement) {
            super(patternString);
            if (vmargsJVMOptionElement != null) {
                this.values.addAll(vmargsJVMOptionElement.values);
            }
        }

        boolean matches(String element) {
            return !CLIBootstrap.this.jvmMainSetting.isSet() && super.matches(element);
        }
    }

    private class Option
    extends CommandLineElement {
        Option(String patternString) {
            super(patternString);
        }
    }

    private class CommandLineElement {
        private final Pattern pattern;
        Matcher matcher;
        final List<String> values = new ArrayList<String>();

        CommandLineElement(String patternString) {
            this.pattern = Pattern.compile(patternString);
        }

        final boolean matchesPattern(String element) {
            this.matcher = this.pattern.matcher(element);
            return this.matcher.matches();
        }

        boolean matches(String element) {
            return this.matchesPattern(element);
        }

        int processValue(String[] args, int slot) throws UserError {
            this.values.add(args[slot++]);
            return slot;
        }

        void addToAgentArgs(String element) {
        }

        boolean isNextArg(String[] args, int currentSlot) {
            return currentSlot < args.length - 1;
        }

        String nextArg(String[] args, int currentSlot) {
            return args[currentSlot + 1];
        }

        void ensureNonOptionNextArg(String[] args, int currentSlot) throws UserError {
            if (currentSlot >= args.length - 1 || args[currentSlot + 1].charAt(0) == '-') {
                throw new UserError("Command line element " + args[currentSlot] + " requires non-option value");
            }
        }

        StringBuilder format(StringBuilder commandLine) {
            return this.format(commandLine, true);
        }

        StringBuilder format(StringBuilder commandLine, boolean useQuotes) {
            boolean needSep = false;
            for (String value : this.values) {
                if (needSep) {
                    commandLine.append(this.valueSep());
                }
                this.format(commandLine, useQuotes, value);
                needSep = true;
            }
            commandLine.append(' ');
            return commandLine;
        }

        char valueSep() {
            return ' ';
        }

        StringBuilder format(StringBuilder commandLine, boolean useQuotes, String v) {
            if (commandLine.length() > 0) {
                commandLine.append(' ');
            }
            commandLine.append(useQuotes ? CLIBootstrap.quoteSuppressTokenSubst(v) : v);
            return commandLine;
        }
    }

    private class AgentArgs {
        private final StringBuilder args = new StringBuilder("=mode=acscript");
        private char sep = (char)44;

        AgentArgs() {
            String appcPath = System.getProperty("acc.APPCPATH");
            if (appcPath != null && appcPath.length() > 0) {
                this.add("appcpath=" + CLIBootstrap.quoteSuppressTokenSubst(appcPath));
            }
        }

        final void add(String item) {
            this.args.append(this.sep).append(item);
        }

        final void addACCArg(String accArg) {
            this.add("arg=" + accArg);
        }

        public String toString() {
            return this.args.toString();
        }
    }
}

