/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ACCStartupContext
extends StartupContext {
    public ACCStartupContext() {
        super(ACCStartupContext.accEnvironment());
    }

    private static Properties accEnvironment() {
        Properties result = ASMainHelper.parseAsEnv((File)ACCStartupContext.getRootDirectory());
        result.setProperty("com.sun.aas.installRoot", ACCStartupContext.getRootDirectory().getAbsolutePath());
        return result;
    }

    private static File getRootDirectory() {
        URI jarURI = null;
        try {
            jarURI = ACCClassLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (jarURI.getScheme().startsWith("http")) {
            return new File(System.getProperty("user.home"));
        }
        File jarFile = new File(jarURI);
        File dirFile = jarFile.getParentFile().getParentFile();
        return dirFile;
    }
}

