/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.client.acc.AppClientCommand;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppclientCommandArguments {
    private static final Logger logger = Logger.getLogger(AppclientCommandArguments.class.getName());
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final Logger accLogger = LogDomains.getLogger(AppclientCommandArguments.class, (String)"javax.enterprise.system.container.appclient");
    private static final String TEXTAUTH = "textauth";
    private static final String NOAPPINVOKE = "noappinvoke";
    private static final String MAINCLASS = "mainclass";
    private static final String NAME = "name";
    private static final String XML = "xml";
    private static final String CONFIGXML = "configxml";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String PASSWORDFILE = "passwordfile";
    private static final String TARGETSERVER = "targetserver";
    private static final String USAGE = "usage";
    private static final String HELP = "help";
    static final String PASSWORD_FILE_PASSWORD_KEYWORD = "PASSWORD";
    private static final String[] valuedArgNames = new String[]{"mainclass", "name", "xml", "configxml", "user", "password", "passwordfile", "targetserver"};
    private static final String[] unvaluedArgNames = new String[]{"textauth", "noappinvoke", "usage", "help"};
    private static LocalStringManager localStrings = new LocalStringManagerImpl(AppClientCommand.class);
    private Map<String, AtomicReference<String>> valuedArgs = this.initValuedArgs();
    private Map<String, AtomicBoolean> unvaluedArgs = this.initUnvaluedArgs();
    private List<String> unrecognizedArgs = new ArrayList<String>();
    private char[] password = null;
    private boolean isPasswordOptionUsed = false;
    private String configPathToUse = null;

    private Map<String, AtomicReference<String>> initValuedArgs() {
        HashMap<String, AtomicReference<String>> result = new HashMap<String, AtomicReference<String>>();
        for (String s : valuedArgNames) {
            result.put(s, new AtomicReference<Object>(null));
        }
        return result;
    }

    private Map<String, AtomicBoolean> initUnvaluedArgs() {
        HashMap<String, AtomicBoolean> result = new HashMap<String, AtomicBoolean>();
        for (String s : unvaluedArgNames) {
            result.put(s, new AtomicBoolean(false));
        }
        return result;
    }

    public static AppclientCommandArguments newInstance(List<String> appclientCommandArgs) throws UserError {
        AppclientCommandArguments result = new AppclientCommandArguments();
        result.processAppclientArgs(appclientCommandArgs);
        return result;
    }

    private AppclientCommandArguments() {
    }

    public boolean isTextauth() {
        return this.unvaluedArgs.get(TEXTAUTH).get();
    }

    public boolean isNoappinvoke() {
        return this.unvaluedArgs.get(NOAPPINVOKE).get();
    }

    public boolean isUsage() {
        return this.unvaluedArgs.get(USAGE).get();
    }

    public boolean isHelp() {
        return this.unvaluedArgs.get(HELP).get();
    }

    public String getUser() {
        return this.valuedArgs.get(USER).get();
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getName() {
        return this.valuedArgs.get(NAME).get();
    }

    public String getTargetServer() {
        return this.valuedArgs.get(TARGETSERVER).get();
    }

    private String getXML() {
        return this.valuedArgs.get(XML).get();
    }

    private String getConfigXML() {
        return this.valuedArgs.get(CONFIGXML).get();
    }

    public String getConfigFilePath() {
        if (this.configPathToUse == null) {
            this.configPathToUse = this.chooseConfigFilePath();
        }
        return this.configPathToUse;
    }

    private String chooseConfigFilePath() {
        boolean isConfig = logger.isLoggable(Level.CONFIG);
        String pathToUse = null;
        pathToUse = this.getXML();
        if (pathToUse != null) {
            if (isConfig) {
                logger.log(Level.CONFIG, "Choosing app client container config from -xml option: {0}", pathToUse);
            }
        } else {
            pathToUse = this.getConfigXML();
            if (pathToUse != null && isConfig) {
                logger.log(Level.CONFIG, "Choosing app client container config from -configxml option: {0}", pathToUse);
            }
        }
        return pathToUse;
    }

    public String getMainclass() {
        return this.valuedArgs.get(MAINCLASS).get();
    }

    public List<String> getAppArgs() {
        return this.unrecognizedArgs;
    }

    private void processAppclientArgs(List<String> commandArgs) throws UserError {
        boolean isConfig = logger.isLoggable(Level.CONFIG);
        StringBuilder sb = isConfig ? new StringBuilder("Arguments from appclient command:") : null;
        for (int slot = 0; slot < commandArgs.size(); ++slot) {
            String arg = commandArgs.get(slot);
            if (arg.charAt(0) == '-') {
                if (this.valuedArgs.containsKey(arg = arg.substring(1))) {
                    if (slot < commandArgs.size()) {
                        String value;
                        if ((value = commandArgs.get(++slot)).length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                            value = value.substring(1, value.length() - 1);
                        }
                        if (arg.equals(PASSWORD)) {
                            this.password = value.toCharArray();
                            this.isPasswordOptionUsed = true;
                            if (isConfig) {
                                sb.append(LINE_SEP).append("  ").append(arg).append("=???");
                            }
                        } else if (isConfig) {
                            sb.append(LINE_SEP).append("  ").append(arg).append("=").append(value);
                        }
                        this.valuedArgs.get(arg).set(value);
                        if (!arg.equals(PASSWORDFILE)) continue;
                        this.processPasswordFile(value);
                        continue;
                    }
                    throw new IllegalArgumentException(arg + "=?");
                }
                if (this.unvaluedArgs.containsKey(arg)) {
                    this.unvaluedArgs.get(arg).set(Boolean.TRUE);
                    if (!isConfig) continue;
                    sb.append(LINE_SEP).append("  ").append(arg);
                    continue;
                }
                this.unrecognizedArgs.add(arg);
                continue;
            }
            this.unrecognizedArgs.add(arg);
        }
        if (isConfig) {
            logger.config(sb.toString());
        }
        this.validateOptions();
    }

    private void processPasswordFile(String passwordFilePath) throws UserError {
        try {
            File pwFile = Util.verifyFilePath(passwordFilePath);
            this.password = this.loadPasswordFromFile(pwFile);
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString(this.getClass(), "appclient.errorReadingFromPasswordFile", "Error reading the password from the password file {0}", new Object[]{passwordFilePath});
            throw new UserError(msg, e);
        }
    }

    private char[] loadPasswordFromFile(File pwFile) throws IOException, UserError {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(pwFile));
            Properties props = new Properties();
            props.load(inputStream);
            if (props.containsKey(PASSWORD_FILE_PASSWORD_KEYWORD)) {
                char[] cArray = props.getProperty(PASSWORD_FILE_PASSWORD_KEYWORD).toCharArray();
                return cArray;
            }
            String msg = localStrings.getLocalString(this.getClass(), "appclient.noPasswordInFile", "The file {0} specified by the -passwordfile option should contain a setting PASSWORD=client-password-to-use but does not", new Object[]{pwFile.getAbsolutePath()});
            throw new UserError(msg);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void validateOptions() throws UserError {
        this.ensureAtMostOneOfNameAndMainClass();
        this.warnAboutPasswordUsage();
    }

    private void ensureAtMostOneOfNameAndMainClass() throws UserError {
        if (this.getMainclass() != null && this.getName() != null) {
            throw new UserError(localStrings.getLocalString(this.getClass(), "appclient.mainclassOrNameNotBoth", "Specify either -mainclass or -name but not both to identify the app client to be run"));
        }
    }

    private void warnAboutPasswordUsage() {
        if (this.isPasswordOptionUsed) {
            String msg = accLogger.getResourceBundle().getString("appclient.password.deprecated");
            logger.warning(msg);
        }
    }
}

