/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;

public class ACCAgentClassLoader
extends URLClassLoader {
    private boolean isActive = true;

    public ACCAgentClassLoader(ClassLoader parent) {
        super(ACCAgentClassLoader.userClassPath(), (ClassLoader)ACCAgentClassLoader.prepareLoader(ACCAgentClassLoader.GFSystemClassPath(), parent.getParent()));
    }

    private static URLClassLoader prepareLoader(final URL[] urls, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    public ACCAgentClassLoader(URL[] urls) {
        super(urls);
    }

    public ACCAgentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ACCAgentClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isActive && this.isStillActive()) {
            return super.loadClass(name);
        }
        return this.getParent().loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        if (this.isActive && this.isStillActive()) {
            return super.getResource(name);
        }
        return this.getParent().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isActive && this.isStillActive()) {
            return super.getResources(name);
        }
        return this.getParent().getResources(name);
    }

    private boolean isStillActive() {
        if (this.isActive) {
            String propValue = System.getProperty("org.glassfish.appclient.acc.agentLoaderDone");
            this.isActive = propValue != null;
        }
        return this.isActive;
    }

    private static URL[] userClassPath() {
        URI GFSystemURI = ACCAgentClassLoader.GFSystemURI();
        List<URL> result = ACCAgentClassLoader.classPathToURLs(System.getProperty("java.class.path"));
        ListIterator<URL> it = result.listIterator();
        while (it.hasNext()) {
            URL url = it.next();
            try {
                if (!url.toURI().equals(GFSystemURI)) continue;
                it.remove();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    private static URL[] GFSystemClassPath() {
        try {
            return new URL[]{ACCAgentClassLoader.GFSystemURI().normalize().toURL()};
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static URI GFSystemURI() {
        try {
            Class<?> agentClass = Class.forName("org.glassfish.appclient.client.acc.agent.AppClientContainerAgent");
            return agentClass.getProtectionDomain().getCodeSource().getLocation().toURI().normalize();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static List<URL> classPathToURLs(String classPath) {
        if (classPath == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            for (String classPathElement : classPath.split(File.pathSeparator)) {
                result.add(new File(classPathElement).toURI().normalize().toURL());
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

