/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class AppClientGroupFacadeGenerator {
    private static final String GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME = "org.glassfish.appclient.client.AppClientGroupFacade";
    private static final Attributes.Name GLASSFISH_APPCLIENT_GROUP = new Attributes.Name("GlassFish-AppClient-Group");
    private static final String GF_CLIENT_MODULE_NAME = "org.glassfish.appclient.gf-client-module";
    private static final String GROUP_FACADE_ALREADY_GENERATED = "groupFacadeAlreadyGenerated";
    static final String GROUP_FACADE_DOWNLOAD_KEY = "earFacadeDownload";
    private DeploymentContext dc;
    private AppClientDeployerHelper helper;
    @Inject
    private ModulesRegistry modulesRegistry;
    private ClassLoader gfClientModuleClassLoader = null;

    void run(AppClientDeployerHelper helper) {
        this.dc = helper.dc();
        this.helper = helper;
        if (!this.groupFacadeAlreadyGenerated().get()) {
            this.generateGroupFacade();
        }
    }

    private ClassLoader gfClientModuleClassLoader() {
        if (this.gfClientModuleClassLoader == null) {
            for (Module module : this.modulesRegistry.getModules(GF_CLIENT_MODULE_NAME)) {
                this.gfClientModuleClassLoader = module.getClassLoader();
            }
        }
        return this.gfClientModuleClassLoader;
    }

    private AtomicBoolean groupFacadeAlreadyGenerated() {
        AtomicBoolean groupFacadeAlreadyGenerated = (AtomicBoolean)this.dc.getTransientAppMetaData(GROUP_FACADE_ALREADY_GENERATED, AtomicBoolean.class);
        if (groupFacadeAlreadyGenerated == null) {
            groupFacadeAlreadyGenerated = new AtomicBoolean(false);
            this.dc.addTransientAppMetaData(GROUP_FACADE_ALREADY_GENERATED, (Object)groupFacadeAlreadyGenerated);
        }
        return groupFacadeAlreadyGenerated;
    }

    private void recordGroupFacadeGeneration() {
        ((AtomicBoolean)this.dc.getTransientAppMetaData(GROUP_FACADE_ALREADY_GENERATED, AtomicBoolean.class)).set(true);
    }

    private void generateGroupFacade() {
        Application application = (Application)this.dc.getModuleMetaData(Application.class);
        Collection appClients = application.getModuleDescriptorsByType(XModuleType.CAR);
        StringBuilder appClientGroupListSB = new StringBuilder();
        for (ModuleDescriptor md : appClients) {
            appClientGroupListSB.append(appClientGroupListSB.length() > 0 ? " " : "").append(this.earDirUserURIText(this.dc)).append(this.appClientFacadeUserURI(md.getArchiveUri()));
        }
        try {
            this.generateAndRecordEARFacade(this.dc, this.dc.getScratchDir("xml").getParentFile(), AppClientGroupFacadeGenerator.generatedEARFacadeName(application.getAppName()), appClientGroupListSB.toString());
            this.recordGroupFacadeGeneration();
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private String earDirUserURIText(DeploymentContext dc) {
        DeployCommandParameters deployParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String appName = deployParams.name();
        try {
            return VersioningUtils.getUntaggedName((String)appName) + "Client/";
        }
        catch (VersioningSyntaxException ex) {
            Logger.getLogger(AppClientGroupFacadeGenerator.class.getName()).log(Level.SEVERE, null, ex);
            return appName;
        }
    }

    private String appClientFacadeUserURI(String appClientModuleURIText) {
        if (appClientModuleURIText.endsWith("_jar")) {
            appClientModuleURIText = appClientModuleURIText.substring(0, appClientModuleURIText.lastIndexOf("_jar")) + ".jar";
        }
        int dotJar = appClientModuleURIText.lastIndexOf(".jar");
        String appClientFacadePath = appClientModuleURIText.substring(0, dotJar) + "Client.jar";
        return appClientFacadePath;
    }

    public static String generatedEARFacadeName(String earName) {
        return AppClientGroupFacadeGenerator.generatedEARFacadePrefix(earName) + ".jar";
    }

    public static String generatedEARFacadePrefix(String earName) {
        return earName + "Client";
    }

    private void generateAndRecordEARFacade(DeploymentContext dc, File appScratchDir, String facadeFileName, String appClientGroupList) throws IOException {
        File generatedJar = new File(appScratchDir, facadeFileName);
        OutputJarArchive facadeArchive = new OutputJarArchive();
        facadeArchive.create(generatedJar.toURI());
        Manifest manifest = facadeArchive.getManifest();
        Attributes mainAttrs = manifest.getMainAttributes();
        mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrs.put(Attributes.Name.MAIN_CLASS, GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME);
        mainAttrs.put(GLASSFISH_APPCLIENT_GROUP, appClientGroupList);
        OutputStream manifestOutputStream = facadeArchive.putNextEntry("META-INF/MANIFEST.MF");
        manifest.write(manifestOutputStream);
        facadeArchive.closeEntry();
        this.writeMainClass((WritableArchive)facadeArchive);
        this.copyArtifactsFromOtherDeployers((WritableArchive)facadeArchive, dc);
        facadeArchive.close();
        HashSet<Artifacts.FullAndPartURIs> downloads = new HashSet<Artifacts.FullAndPartURIs>();
        Artifacts.FullAndPartURIs download = new Artifacts.FullAndPartURIs(generatedJar.toURI(), facadeFileName);
        downloads.add(download);
        this.helper.earLevelDownloads().add(download);
        dc.addTransientAppMetaData(GROUP_FACADE_DOWNLOAD_KEY, (Object)download);
    }

    private void writeMainClass(WritableArchive facadeArchive) throws IOException {
        String mainClassResourceName = GLASSFISH_APPCLIENT_GROUP_FACADE_CLASS_NAME.replace('.', '/') + ".class";
        OutputStream os = facadeArchive.putNextEntry(mainClassResourceName);
        try {
            InputStream is = this.openByteCodeStream("/" + mainClassResourceName);
            AppClientDeployerHelper.copyStream(is, os);
            is.close();
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected InputStream openByteCodeStream(String resourceName) throws IOException {
        URL url = this.gfClientModuleClassLoader().getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(resourceName);
        }
        InputStream is = url.openStream();
        return is;
    }

    private void copyArtifactsFromOtherDeployers(WritableArchive facadeArchive, DeploymentContext dc) throws IOException {
        ClientArtifactsManager artifacts = ClientArtifactsManager.get((DeploymentContext)dc);
        for (Artifacts.FullAndPartURIs artifact : artifacts.artifacts()) {
            OutputStream os = facadeArchive.putNextEntry(artifact.getPart().toASCIIString());
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(artifact.getFull())));
            AppClientDeployerHelper.copyStream(is, os);
            try {
                ((InputStream)is).close();
                facadeArchive.closeEntry();
            }
            catch (IOException ignore) {}
        }
    }
}

