/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CombinedXPath {
    private static final Logger logger = Logger.getLogger(CombinedXPath.class.getName());
    private static final String OWNED_PROPERTY_NAME = "owned";
    private static final String DEFAULTED_PROPERTY_NAME = "defaulted";
    private static final String MERGED_PROPERTY_NAME = "merged";
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();
    private static final XPath xPath = xPathFactory.newXPath();
    private static LSSerializer lsSerializer = null;
    private static LSOutput lsOutput = null;
    private final String parentPath;
    private final String targetRelativePath;
    private final XPathExpression targetExpr;
    private final XPathExpression parentExpr;

    static List<CombinedXPath> parse(Properties p) {
        ArrayList<CombinedXPath> result = new ArrayList<CombinedXPath>();
        result.addAll(CombinedXPath.parse(p, Type.DEFAULTED));
        result.addAll(CombinedXPath.parse(p, Type.MERGED));
        return result;
    }

    private static List<CombinedXPath> parse(Properties p, Type type) {
        ArrayList<CombinedXPath> result = new ArrayList<CombinedXPath>();
        String refs = p.getProperty(type.propertyName);
        block5: for (String ref : refs.split(",")) {
            String[] paths = ref.split(":");
            if (paths.length != 2) {
                throw new IllegalArgumentException(ref);
            }
            switch (type) {
                case OWNED: {
                    result.add(new OwnedXPath(xPath, paths[0], paths[1]));
                    continue block5;
                }
                case MERGED: {
                    result.add(new MergedXPath(xPath, paths[0], paths[1]));
                    continue block5;
                }
                case DEFAULTED: {
                    result.add(new DefaultedXPath(xPath, paths[0], paths[1]));
                }
            }
        }
        return result;
    }

    CombinedXPath(XPath xPath, String parentPath, String targetRelativePath) {
        this.parentPath = parentPath;
        this.targetRelativePath = targetRelativePath;
        try {
            this.parentExpr = xPath.compile(parentPath);
            this.targetExpr = xPath.compile(parentPath + targetRelativePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String parentPath() {
        return this.parentPath;
    }

    String targetRelativePath() {
        return this.targetRelativePath;
    }

    XPathExpression targetExpr() {
        return this.targetExpr;
    }

    XPathExpression parentExpr() {
        return this.parentExpr;
    }

    abstract void process(Document var1, Document var2) throws XPathExpressionException;

    protected void insert(Document originalDOM, Node insertionPoint, Node newNode) throws XPathExpressionException {
        if (newNode instanceof Attr) {
            this.setAttr(originalDOM, insertionPoint, (Attr)newNode);
        } else {
            this.insertNode(originalDOM, insertionPoint, newNode);
        }
    }

    private void setAttr(Document originalDOM, Node insertionPoint, Attr newAttr) throws XPathExpressionException {
        Element parent = insertionPoint == null ? (Element)this.parentExpr().evaluate(originalDOM, XPathConstants.NODE) : ((Attr)insertionPoint).getOwnerElement();
        parent.setAttribute(newAttr.getName(), newAttr.getValue());
    }

    private void insertNode(Document originalDOM, Node insertionPoint, Node newNode) throws XPathExpressionException {
        Node parentNode = insertionPoint == null ? (Node)this.parentExpr().evaluate(originalDOM, XPathConstants.NODE) : insertionPoint.getParentNode();
        parentNode.insertBefore(originalDOM.adoptNode(newNode), insertionPoint);
    }

    private static Node ancestry(Node original) {
        Node nextAncestor;
        Attr thisAttr = null;
        if (original.getNodeType() == 2) {
            thisAttr = (Attr)original;
            nextAncestor = thisAttr.getOwnerElement();
        } else {
            nextAncestor = original.getParentNode();
        }
        Element displayAncestor = original.getOwnerDocument().createElement(nextAncestor.getNodeName());
        if (thisAttr != null) {
            displayAncestor.setAttribute(thisAttr.getName(), thisAttr.getValue());
        }
        for (nextAncestor = nextAncestor.getParentNode(); nextAncestor != null && nextAncestor instanceof Element; nextAncestor = nextAncestor.getParentNode()) {
            Element newDisplayAncestor = original.getOwnerDocument().createElement(nextAncestor.getNodeName());
            NamedNodeMap attrs = nextAncestor.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                newDisplayAncestor.setAttribute(attrs.item(i).getNodeName(), attrs.item(i).getNodeValue());
            }
            newDisplayAncestor.appendChild(displayAncestor);
            displayAncestor = newDisplayAncestor;
        }
        return displayAncestor;
    }

    private static String toXML(Node node) {
        StringWriter writer = new StringWriter();
        CombinedXPath.writeXML(node, writer);
        return ((Object)writer).toString();
    }

    private static synchronized void writeXML(Node node, Writer writer) {
        try {
            if (lsSerializer == null) {
                DOMImplementation domImpl = DOMImplementationRegistry.newInstance().getDOMImplementation("");
                DOMImplementationLS domLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
                lsOutput = domLS.createLSOutput();
                lsOutput.setEncoding("UTF-8");
                lsSerializer = domLS.createLSSerializer();
            }
            lsOutput.setCharacterStream(writer);
            lsSerializer.write(node, lsOutput);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static class DefaultedXPath
    extends CombinedXPath {
        DefaultedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            int i;
            NodeList replacementNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            if (replacementNodes.getLength() == 0) {
                return;
            }
            NodeList originalNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            Node insertionPoint = originalNodes.getLength() > 0 ? originalNodes.item(0).getPreviousSibling() : null;
            boolean isDetailed = logger.isLoggable(Level.FINER);
            for (i = 0; i < originalNodes.getLength(); ++i) {
                if (isDetailed) {
                    logger.log(Level.FINER, "Removing generated node to make way for developer node based on {0}:{1}", new Object[]{this.parentPath(), this.targetRelativePath()});
                }
                this.remove(originalNodes.item(i));
                if (!isDetailed) continue;
                logger.log(Level.FINER, CombinedXPath.toXML(generatedDOM));
            }
            for (i = 0; i < replacementNodes.getLength(); ++i) {
                this.insert(generatedDOM, insertionPoint, replacementNodes.item(i));
                if (!isDetailed) continue;
                logger.log(Level.FINER, CombinedXPath.toXML(generatedDOM));
            }
        }

        private void remove(Node originalNode) {
            if (originalNode instanceof Attr) {
                this.removeAttr((Attr)originalNode);
            } else {
                this.removeNode(originalNode);
            }
        }

        private void removeNode(Node originalNode) {
            originalNode.getParentNode().removeChild(originalNode);
        }

        private void removeAttr(Attr originalAttr) {
            Element parent = originalAttr.getOwnerElement();
            parent.removeAttribute(originalAttr.getName());
        }
    }

    static class MergedXPath
    extends CombinedXPath {
        MergedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            NodeList developerNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            NodeList generatedNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            Node insertionPoint = generatedNodes.getLength() > 0 ? generatedNodes.item(0) : null;
            boolean isDetailed = logger.isLoggable(Level.FINER);
            for (int i = 0; i < developerNodes.getLength(); ++i) {
                if (isDetailed) {
                    logger.log(Level.FINER, "Inserting new node due to {0}:{1}", new Object[]{this.parentPath(), this.targetRelativePath()});
                }
                this.insert(generatedDOM, insertionPoint, developerNodes.item(i));
                if (!isDetailed) continue;
                logger.log(Level.FINER, CombinedXPath.toXML(generatedDOM));
            }
        }
    }

    static class OwnedXPath
    extends CombinedXPath {
        OwnedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        OWNED("owned"),
        DEFAULTED("defaulted"),
        MERGED("merged");

        private String propertyName;

        private Type(String propName) {
            this.propertyName = propName;
        }
    }
}

