/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.AppClientDeployer;
import org.glassfish.appclient.server.core.ApplicationSignedJARManager;
import org.glassfish.appclient.server.core.ClientJarMakerUtils;
import org.glassfish.appclient.server.core.NestedAppClientDeployerHelper;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppClientDeployerHelper {
    private static final String PERSISTENCE_XML_PATH = "META-INF/persistence.xml";
    private final DeploymentContext dc;
    private final ApplicationClientDescriptor appClientDesc;
    protected final AppClientArchivist archivist;
    private final String appName;
    private final String clientName;
    private final ClassLoader gfClientModuleClassLoader;
    private final Application application;
    private final Habitat habitat;
    private Logger logger;

    static AppClientDeployerHelper newInstance(DeploymentContext dc, AppClientArchivist archivist, ClassLoader gfClientModuleLoader, Habitat habitat, ASJarSigner jarSigner) throws IOException {
        ApplicationClientDescriptor bundleDesc = (ApplicationClientDescriptor)dc.getModuleMetaData(ApplicationClientDescriptor.class);
        Application application = bundleDesc.getApplication();
        boolean insideEar = !application.isVirtual();
        return insideEar ? new NestedAppClientDeployerHelper(dc, bundleDesc, archivist, gfClientModuleLoader, application, habitat, jarSigner) : new StandaloneAppClientDeployerHelper(dc, bundleDesc, archivist, gfClientModuleLoader, application, habitat);
    }

    protected AppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist, ClassLoader gfClientModuleClassLoader, Application application, Habitat habitat) throws IOException {
        this.logger = this.logger = LogDomains.getLogger(AppClientDeployerHelper.class, (String)"javax.enterprise.system.container.appclient");
        this.dc = dc;
        this.appClientDesc = bundleDesc;
        this.archivist = archivist;
        this.habitat = habitat;
        this.gfClientModuleClassLoader = gfClientModuleClassLoader;
        this.appName = this.appClientDesc.getApplication().getRegistrationName();
        this.clientName = this.appClientDesc.getModuleDescriptor().getArchiveUri();
        this.application = application;
    }

    public abstract URI facadeServerURI(DeploymentContext var1);

    public abstract URI facadeUserURI(DeploymentContext var1);

    public abstract URI groupFacadeUserURI(DeploymentContext var1);

    public abstract URI groupFacadeServerURI(DeploymentContext var1);

    protected abstract String facadeFileNameAndType(DeploymentContext var1);

    public abstract URI appClientUserURI(DeploymentContext var1);

    public abstract URI appClientUserURIForFacade(DeploymentContext var1);

    public abstract URI appClientServerURI(DeploymentContext var1);

    public abstract URI appClientServerOriginalAnchor(DeploymentContext var1);

    public abstract URI appClientURIWithinApp(DeploymentContext var1);

    public abstract String pathToAppclientWithinApp(DeploymentContext var1);

    public abstract URI URIWithinAppDir(DeploymentContext var1, URI var2);

    protected abstract String facadeClassPath();

    protected abstract String PUScanTargets();

    public ApplicationSignedJARManager signedJARManager() {
        return null;
    }

    public abstract void createAndAddLibraryJNLPs(AppClientDeployerHelper var1, TokenHelper var2, Map<String, DynamicContent> var3) throws IOException;

    public Map<String, Map<URI, StaticContent>> signingAliasToJar() {
        return Collections.EMPTY_MAP;
    }

    public final DeploymentContext dc() {
        return this.dc;
    }

    public ApplicationClientDescriptor appClientDesc() {
        return this.appClientDesc;
    }

    public String appName() {
        return this.appName;
    }

    public String appName(DeploymentContext dc) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return params.name();
    }

    public String clientName() {
        return this.clientName;
    }

    public abstract FixedContent fixedContentWithinEAR(String var1);

    public abstract File rootForSignedFilesInApp();

    File JAROfExpandedSubmodule(URI candidateSubmoduleURI) throws IOException {
        FileArchive source = new FileArchive();
        source.open(this.dc().getSource().getParentArchive().getURI().resolve(this.expandedDirURI(candidateSubmoduleURI)));
        OutputJarArchive target = new OutputJarArchive();
        target.create(this.dc().getScratchDir("xml").toURI().resolve(candidateSubmoduleURI));
        Manifest mf = source.getManifest();
        OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
        mf.write(os);
        target.closeEntry();
        ClientJarMakerUtils.copyArchive((ReadableArchive)source, (WritableArchive)target, Collections.EMPTY_SET);
        target.close();
        return new File(target.getURI());
    }

    private URI expandedDirURI(URI submoduleURI) {
        URI possibleExpandedDirURI = this.dc().getSource().getParentArchive().getURI().resolve(submoduleURI);
        File possibleExpandedDir = new File(possibleExpandedDirURI);
        if (possibleExpandedDir.exists() && possibleExpandedDir.isDirectory()) {
            return submoduleURI;
        }
        String uriText = submoduleURI.toString().replace("/", "__");
        int lastDot = uriText.lastIndexOf(46);
        return URI.create(uriText.substring(0, lastDot) + "_" + uriText.substring(lastDot + 1));
    }

    private void initGeneratedManifest(Manifest sourceManifest, Manifest generatedManifest, String classPath, String PUScanTargets, Application application) {
        Attributes sourceMainAttrs = sourceManifest.getMainAttributes();
        Attributes facadeMainAttrs = generatedManifest.getMainAttributes();
        facadeMainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        facadeMainAttrs.put(Attributes.Name.MAIN_CLASS, "org.glassfish.appclient.client.AppClientFacade");
        facadeMainAttrs.put(AppClientDeployer.GLASSFISH_APPCLIENT_MAIN_CLASS, sourceMainAttrs.getValue(Attributes.Name.MAIN_CLASS));
        facadeMainAttrs.put(AppClientArchivist.GLASSFISH_APPCLIENT, this.appClientUserURIForFacade(this.dc).toASCIIString());
        String splash = sourceMainAttrs.getValue(AppClientDeployer.SPLASH_SCREEN_IMAGE);
        if (splash != null) {
            facadeMainAttrs.put(AppClientDeployer.SPLASH_SCREEN_IMAGE, splash);
        }
        facadeMainAttrs.put(Attributes.Name.CLASS_PATH, classPath);
        if (PUScanTargets != null) {
            facadeMainAttrs.put(AppClientArchivist.GLASSFISH_CLIENT_PU_SCAN_TARGETS_NAME, PUScanTargets);
        }
        facadeMainAttrs.put(AppClientDeployer.GLASSFISH_APP_NAME, application.getAppName());
        facadeMainAttrs.put(AppClientArchivist.GLASSFISH_ANCHOR_DIR, this.anchorDirRelativeToClient());
        if (!this.appClientDesc.isStandalone()) {
            facadeMainAttrs.put(AppClientArchivist.GLASSFISH_GROUP_FACADE, this.relativePathToGroupFacade());
        }
    }

    private String anchorDirRelativeToClient() {
        String pathToClient = this.pathToAppclientWithinApp(this.dc);
        StringBuilder sb = new StringBuilder();
        for (char c : pathToClient.toCharArray()) {
            if (c != '/') continue;
            sb.append("../");
        }
        return sb.toString();
    }

    protected URI relativeURIToGroupFacade() {
        return URI.create(this.relativePathToGroupFacade());
    }

    private String relativePathToGroupFacade() {
        StringBuilder sb = new StringBuilder(this.anchorDirRelativeToClient());
        try {
            sb.append("../").append(VersioningUtils.getUntaggedName((String)this.appName)).append("Client.jar");
        }
        catch (VersioningSyntaxException ex) {
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return sb.toString();
    }

    private void writeUpdatedDescriptors(OutputJarArchive facadeArchive, ApplicationClientDescriptor acd) throws IOException {
        this.archivist.setDescriptor((RootDeploymentDescriptor)acd);
        this.archivist.writeDeploymentDescriptors((WritableArchive)facadeArchive);
    }

    protected void prepareJARs() throws IOException, URISyntaxException {
        if (((ProcessEnvironment)this.habitat.getComponent(ProcessEnvironment.class)).getProcessType().isEmbedded()) {
            return;
        }
        this.generateAppClientFacade();
    }

    protected final void generateAppClientFacade() throws IOException, URISyntaxException {
        OutputJarArchive facadeArchive = new OutputJarArchive();
        File facadeFile = new File(this.facadeServerURI(this.dc));
        if (!facadeFile.getParentFile().exists()) {
            facadeFile.getParentFile().mkdirs();
        }
        facadeArchive.create(this.facadeServerURI(this.dc));
        ReadableArchive source = this.dc.getSource();
        Manifest sourceManifest = source.getManifest();
        if (sourceManifest == null) {
            String msg = this.logger.getResourceBundle().getString("enterprise.deployment.appclient.noManifest");
            throw new IOException(MessageFormat.format(msg, source.getURI().toASCIIString()));
        }
        Manifest facadeManifest = facadeArchive.getManifest();
        this.initGeneratedManifest(sourceManifest, facadeManifest, this.facadeClassPath(), this.PUScanTargets(), this.application);
        Attributes srcMainAttrs = sourceManifest.getMainAttributes();
        if (srcMainAttrs == null) {
            String msg = this.logger.getResourceBundle().getString("enterprise.deployment.appclient.noMainAttrs");
            throw new IOException(MessageFormat.format(msg, source.getURI().toASCIIString()));
        }
        String splash = srcMainAttrs.getValue(AppClientDeployer.SPLASH_SCREEN_IMAGE);
        if (splash != null) {
            ClientJarMakerUtils.copy(source, (WritableArchive)facadeArchive, splash);
        }
        OutputStream os = facadeArchive.putNextEntry("META-INF/MANIFEST.MF");
        facadeManifest.write(os);
        facadeArchive.closeEntry();
        this.writeUpdatedDescriptors(facadeArchive, this.appClientDesc);
        this.copyPersistenceUnitXML(source, (WritableArchive)facadeArchive);
        this.copyMainClass((WritableArchive)facadeArchive);
        facadeArchive.close();
    }

    private void copyClass(WritableArchive facadeArchive, String classResourcePath) throws IOException {
        OutputStream os = facadeArchive.putNextEntry(classResourcePath);
        InputStream is = this.openByteCodeStream(classResourcePath);
        AppClientDeployerHelper.copyStream(is, os);
        try {
            is.close();
            facadeArchive.closeEntry();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void copyAgentMainClass(WritableArchive facadeArchive) throws IOException {
        this.copyClass(facadeArchive, "org/glassfish/appclient/client/JWSAppClientContainerMain.class");
    }

    private void copyMainClass(WritableArchive facadeArchive) throws IOException {
        this.copyClass(facadeArchive, "org/glassfish/appclient/client/AppClientFacade.class");
    }

    private void copyPersistenceUnitXML(ReadableArchive sourceClient, WritableArchive facadeArchive) throws IOException {
        InputStream persistenceXMLStream = sourceClient.getEntry(PERSISTENCE_XML_PATH);
        if (persistenceXMLStream != null) {
            OutputStream os = facadeArchive.putNextEntry(PERSISTENCE_XML_PATH);
            AppClientDeployerHelper.copyStream(persistenceXMLStream, os);
            try {
                persistenceXMLStream.close();
                facadeArchive.closeEntry();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    protected InputStream openByteCodeStream(String resourceName) throws IOException {
        URL url = this.gfClientModuleClassLoader.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(resourceName);
        }
        InputStream is = url.openStream();
        return is;
    }

    protected abstract Set<Artifacts.FullAndPartURIs> clientLevelDownloads() throws IOException;

    public abstract Set<Artifacts.FullAndPartURIs> earLevelDownloads() throws IOException;

    protected abstract void addGroupFacadeToEARDownloads();

    static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    Proxy proxy() {
        return new Proxy(this);
    }

    public static class Proxy {
        private final AppClientDeployerHelper helper;

        public Proxy(AppClientDeployerHelper helper) {
            this.helper = helper;
        }

        public AppClientDeployerHelper helper() {
            return this.helper;
        }
    }
}

