/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_create-instance-filesystem")
@Scoped(value=PerLookup.class)
public class CreateLocalInstanceFilesystemCommand
extends LocalInstanceCommand {
    @Param(name="agentport", optional=true)
    private String agentPort;
    @Param(name="agentproperties", optional=true, separator=58)
    private Properties agentProperties;
    @Param(name="instance_name", primary=true)
    private String instanceName0;
    String DASHost;
    int DASPort = -1;
    String DASProtocol;
    boolean dasIsSecure;
    public static final String K_ADMIN_PORT = "agent.adminPort";
    public static final String K_ADMIN_HOST = "agent.adminHost";
    public static final String K_AGENT_PROTOCOL = "agent.protocol";
    public static final String K_CLIENT_HOST = "agent.client.host";
    public static final String K_DAS_HOST = "agent.das.host";
    public static final String K_DAS_PROTOCOL = "agent.das.protocol";
    public static final String K_DAS_PORT = "agent.das.port";
    public static final String K_DAS_IS_SECURE = "agent.das.isSecure";
    public static final String K_MASTER_PASSWORD = "agent.masterpassword";
    public static final String K_SAVE_MASTER_PASSWORD = "agent.saveMasterPassword";
    public static final String AGENT_LISTEN_ADDRESS_NAME = "listenaddress";
    public static final String REMOTE_CLIENT_ADDRESS_NAME = "remoteclientaddress";
    public static final String AGENT_JMX_PROTOCOL_NAME = "agentjmxprotocol";
    public static final String DAS_JMX_PROTOCOL_NAME = "dasjmxprotocol";
    public static final String AGENT_DAS_IS_SECURE = "isDASSecure";
    public static final String NODEAGENT_DEFAULT_DAS_IS_SECURE = "false";
    public static final String NODEAGENT_DEFAULT_DAS_PORT = String.valueOf(4848);
    public static final String NODEAGENT_DEFAULT_HOST_ADDRESS = "0.0.0.0";
    public static final String NODEAGENT_JMX_DEFAULT_PROTOCOL = "rmi_jrmp";
    public static final String HOST_NAME_PROPERTY = "com.sun.aas.hostName";
    private File agentConfigDir;
    private File applicationsDir;
    private File configDir;
    private File generatedDir;
    private File libDir;
    private File docrootDir;
    private File dasPropsFile;
    private Properties dasProperties;
    private File nodeagentPropsFile;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateLocalInstanceFilesystemCommand.class);

    protected void validate() throws CommandException {
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.instanceName0)) {
            throw new CommandException(strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.DASHost)) {
            try {
                this.DASHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                logger.getLogger().warning(strings.get("Instance.unknownHost"));
                logger.getLogger().warning(ex.getLocalizedMessage());
                this.DASHost = "localhost";
            }
        }
        if (this.agentPort != null && !NetUtils.isPortStringValid((String)this.agentPort)) {
            throw new CommandException(strings.get("Instance.invalidAgentPort", new Object[]{this.agentPort}));
        }
        super.validate();
        String agentPath = "agent" + File.separator + "config";
        this.agentConfigDir = new File(this.nodeAgentDir, agentPath);
        this.dasPropsFile = new File(this.agentConfigDir, "das.properties");
        this.nodeagentPropsFile = new File(this.agentConfigDir, "nodeagent.properties");
        this.applicationsDir = new File(this.instanceDir, "applications");
        this.configDir = new File(this.instanceDir, "config");
        this.generatedDir = new File(this.instanceDir, "generated");
        this.libDir = new File(this.instanceDir, "lib");
        this.docrootDir = new File(this.instanceDir, "docroot");
        this.DASHost = this.programOpts.getHost();
        this.DASPort = this.programOpts.getPort();
        this.dasIsSecure = this.programOpts.isSecure();
        if (this.DASPort == -1) {
            this.DASPort = this.dasIsSecure ? 4849 : 4848;
        }
        this.DASProtocol = this.dasIsSecure ? "https" : "http";
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        return this.createDirectories();
    }

    private int createDirectories() throws CommandException {
        boolean createDirsComplete = false;
        File badfile = null;
        while (badfile == null && !createDirsComplete) {
            if (!this.agentConfigDir.isDirectory() && !this.agentConfigDir.mkdirs()) {
                badfile = this.agentConfigDir;
            }
            if (!this.applicationsDir.isDirectory() && !this.applicationsDir.mkdir()) {
                badfile = this.applicationsDir;
            }
            if (!this.configDir.isDirectory() && !this.configDir.mkdir()) {
                badfile = this.configDir;
            }
            if (!this.generatedDir.isDirectory() && !this.generatedDir.mkdir()) {
                badfile = this.generatedDir;
            }
            if (!this.libDir.isDirectory() && !this.libDir.mkdir()) {
                badfile = this.libDir;
            }
            if (!this.docrootDir.isDirectory() && !this.docrootDir.mkdir()) {
                badfile = this.docrootDir;
            }
            createDirsComplete = true;
        }
        try {
            this.writeDasProperties();
            this.writeNodeagentProperties();
        }
        catch (IOException ex) {
            throw new CommandException(strings.get("Instance.cantWriteProperties", new Object[]{this.dasPropsFile.getName(), this.nodeagentPropsFile.getName()}), (Throwable)ex);
        }
        if (badfile != null) {
            throw new CommandException(strings.get("Instance.cannotMkDir", new Object[]{badfile}));
        }
        return 0;
    }

    private void writeDasProperties() throws IOException {
        if (!this.dasPropsFile.isFile()) {
            this.dasPropsFile.createNewFile();
        }
        this.dasProperties = new Properties();
        this.dasProperties.setProperty(K_DAS_HOST, this.DASHost);
        this.dasProperties.setProperty(K_DAS_PORT, String.valueOf(this.DASPort));
        this.dasProperties.setProperty(K_DAS_IS_SECURE, String.valueOf(this.dasIsSecure));
        this.dasProperties.setProperty(K_DAS_PROTOCOL, this.DASProtocol);
        FileOutputStream fos = new FileOutputStream(this.dasPropsFile);
        this.dasProperties.store(fos, strings.get("Instance.dasPropertyComment"));
        fos.close();
    }

    private void writeNodeagentProperties() throws IOException, CommandException {
        if (!this.nodeagentPropsFile.isFile()) {
            this.nodeagentPropsFile.createNewFile();
        }
        String remoteClientAddress = this.getSystemProperty(HOST_NAME_PROPERTY);
        String listenAddress = NODEAGENT_DEFAULT_HOST_ADDRESS;
        String agentProtocol = NODEAGENT_JMX_DEFAULT_PROTOCOL;
        String dasProtocol = this.DASProtocol;
        String isDasSecure = String.valueOf(this.dasIsSecure);
        if (this.agentProperties != null && !this.agentProperties.isEmpty()) {
            remoteClientAddress = this.agentProperties.getProperty(REMOTE_CLIENT_ADDRESS_NAME, this.getSystemProperty(HOST_NAME_PROPERTY));
            listenAddress = this.agentProperties.getProperty(AGENT_LISTEN_ADDRESS_NAME, NODEAGENT_DEFAULT_HOST_ADDRESS);
            agentProtocol = this.agentProperties.getProperty(AGENT_JMX_PROTOCOL_NAME, NODEAGENT_JMX_DEFAULT_PROTOCOL);
            dasProtocol = this.agentProperties.getProperty(DAS_JMX_PROTOCOL_NAME, this.DASProtocol);
            isDasSecure = this.agentProperties.getProperty(NODEAGENT_DEFAULT_DAS_IS_SECURE, String.valueOf(this.dasIsSecure));
        }
        Properties _nodeagentProps = new Properties();
        _nodeagentProps.setProperty(K_CLIENT_HOST, remoteClientAddress);
        _nodeagentProps.setProperty(K_ADMIN_HOST, listenAddress);
        _nodeagentProps.setProperty(K_ADMIN_PORT, String.valueOf(this.getAgentPort()));
        _nodeagentProps.setProperty(K_AGENT_PROTOCOL, agentProtocol);
        _nodeagentProps.setProperty(K_DAS_PROTOCOL, dasProtocol);
        _nodeagentProps.setProperty(K_DAS_IS_SECURE, isDasSecure);
        FileOutputStream fos = new FileOutputStream(this.nodeagentPropsFile);
        _nodeagentProps.store(fos, strings.get("Instance.nodeagentPropertiesComment"));
        fos.close();
    }

    protected int getAgentPort() throws CommandException {
        int port = this.agentPort == null ? NetUtils.getFreePort() : Integer.parseInt(this.agentPort);
        if (!NetUtils.isPortFree((int)port)) {
            throw new CommandException(strings.get("AgentPortInUse", new Object[]{this.agentPort}));
        }
        logger.printDebugMessage("agentPort = " + port);
        return port;
    }
}

