/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-local-instance")
@Scoped(value=PerLookup.class)
public class DeleteLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String instanceName0;
    @Param(name="filesystemonly", primary=false, optional=true, defaultValue="false")
    private boolean localOnly;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DeleteLocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.instanceName0;
        super.validate();
        if (!StringUtils.ok((String)this.getServerDirs().getServerName())) {
            throw new CommandException(strings.get("DeleteInstance.noInstanceName"));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        if (this.isRunning()) {
            throw new CommandException(strings.get("DeleteInstance.running"));
        }
        if (!this.localOnly) {
            this.doRemote();
        }
        this.doLocal();
        return 0;
    }

    private void doRemote() throws CommandException {
        try {
            RemoteCommand rc = new RemoteCommand("delete-instance", this.programOpts, this.env);
            rc.execute(new String[]{"delete-instance", "--nodeagent", this.getServerDirs().getServerParentDir().getName(), this.getServerDirs().getServerName()});
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            String newString = strings.get("DeleteInstance.remoteError", new Object[]{ce.getLocalizedMessage()});
            if (t != null) {
                throw new CommandException(newString, t);
            }
            throw new CommandException(newString);
        }
    }

    private void doLocal() throws CommandException {
        File whackee = this.getServerDirs().getServerDir();
        if (whackee == null || !whackee.isDirectory()) {
            throw new CommandException(strings.get("DeleteInstance.noWhack", new Object[]{whackee}));
        }
        FileUtils.whack((File)whackee);
        if (whackee.isDirectory()) {
            throw new CommandException(strings.get("DeleteInstance.badWhack", new Object[]{whackee}));
        }
    }
}

