/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private String targetName;
    private Domain domain;
    private ArrayList<Server> instances = new ArrayList();

    public Target(String target, Domain domain) {
        this.targetName = target;
        this.domain = domain;
        this.init();
    }

    private void init() {
        if (this.domain.getServerNamed(this.targetName) != null) {
            this.instances.add(this.domain.getServerNamed(this.targetName));
        } else {
            Cluster cluster = null;
            List clList = this.domain.getClusters().getCluster();
            for (Cluster cl : clList) {
                if (!this.targetName.equals(cl.getName())) continue;
                cluster = cl;
                break;
            }
            if (cluster != null) {
                String clusterConfigName = cluster.getConfigRef();
                List svrList = this.domain.getServers().getServer();
                for (Server svr : svrList) {
                    if (!clusterConfigName.equals(svr.getConfigRef())) continue;
                    this.instances.add(svr);
                }
            }
        }
    }

    public List<Server> getInstances() {
        return this.instances;
    }
}

