/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="list-instances")
@I18n(value="list.instances.command")
@Scoped(value=PerLookup.class)
public class ListInstancesCommand
implements AdminCommand,
PostConstruct {
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers servers;
    @Inject
    private Configs configs;
    @Param(optional=true, defaultValue="2000")
    String timeoutInMsecString;
    private List<InstanceInfo> infos = new LinkedList<InstanceInfo>();
    private RemoteInstanceCommandHelper helper;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.env, this.servers, this.configs);
    }

    public void execute(AdminCommandContext context) {
        int timeoutInMsec;
        try {
            timeoutInMsec = Integer.parseInt(this.timeoutInMsecString);
        }
        catch (Exception e) {
            timeoutInMsec = 2000;
        }
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        List serverList = this.servers.getServer();
        if (!this.helper.isDas()) {
            String msg = Strings.get("list.instances.onlyRunsOnDas");
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        for (Server server : serverList) {
            String name = server.getName();
            if (name == null || name.equals("server")) continue;
            InstanceInfo ii = new InstanceInfo(name, this.helper.getAdminPort(server), this.helper.getHost(server), logger, timeoutInMsec);
            this.infos.add(ii);
        }
        StringBuilder sb = new StringBuilder();
        if (this.infos.size() < 1) {
            sb.append(Strings.get("list.instances.none"));
        } else {
            sb.append(InstanceInfo.getFormattedHeader()).append('\n');
            boolean first = true;
            for (InstanceInfo info : this.infos) {
                if (first) {
                    first = false;
                } else {
                    sb.append('\n');
                }
                sb.append(info.toFormattedString());
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(sb.toString());
    }
}

