/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.cluster.CreateLocalInstanceFilesystemCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-local-instance")
@Scoped(value=PerLookup.class)
public final class CreateLocalInstanceCommand
extends CreateLocalInstanceFilesystemCommand {
    @Param(name="filesystemonly", optional=true, defaultValue="false")
    private boolean filesystemOnly = false;
    @Param(name="config", optional=true)
    private String configName;
    @Param(name="cluster", optional=true)
    private String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    private static final String RENDEZVOUS_PROPERTY_NAME = "rendezvousOccurred";
    private String INSTANCE_DOTTED_NAME;
    private String RENDEZVOUS_DOTTED_NAME;
    private boolean _rendezvousOccurred;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateLocalInstanceCommand.class);

    protected void validate() throws CommandException {
        if (this.configName != null && this.clusterName != null) {
            throw new CommandException(strings.get("ConfigClusterConflict"));
        }
        super.validate();
        this.INSTANCE_DOTTED_NAME = "servers.server." + this.instanceName;
        this.RENDEZVOUS_DOTTED_NAME = this.INSTANCE_DOTTED_NAME + ".property." + RENDEZVOUS_PROPERTY_NAME;
        if (!this.filesystemOnly) {
            if (!this.rendezvousWithDAS()) {
                throw new CommandException(strings.get("Unable to rendezvous with DAS on host={0}, port={1}, protocol={2}", new Object[]{this.DASHost, this.DASPort, this.DASProtocol}));
            }
            this._rendezvousOccurred = this.rendezvousOccurred();
            if (this._rendezvousOccurred) {
                throw new CommandException(strings.get("Rendezvous with DAS on host {0}, port {1} has already occurred to create instance {2}", new Object[]{this.DASHost, this.DASPort, this.instanceName}));
            }
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        int exitCode = -1;
        if (!this.filesystemOnly) {
            if (this.isRegisteredToDAS()) {
                if (!this._rendezvousOccurred) {
                    this.setRendezvousOccurred("true");
                    this._rendezvousOccurred = true;
                }
            } else {
                this.registerToDAS();
                this._rendezvousOccurred = true;
            }
        }
        try {
            exitCode = super.executeCommand();
        }
        catch (CommandException ce) {
            String msg = "Something went wrong in creating the local filesystem for instance {0}" + this.instanceName;
            if (ce.getLocalizedMessage() != null) {
                msg = msg + ": " + ce.getLocalizedMessage();
            }
            logger.printError(msg);
            if (!this.filesystemOnly) {
                this.setRendezvousOccurred("false");
                this._rendezvousOccurred = false;
            }
            throw new CommandException(msg, (Throwable)ce);
        }
        return exitCode;
    }

    private boolean rendezvousWithDAS() {
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("uptime", this.DASHost, this.DASPort, this.dasIsSecure, "admin", null, logger.getLogger());
            rac.setConnectTimeout(10000);
            ParameterMap map = new ParameterMap();
            rac.executeCommand(map);
            return true;
        }
        catch (CommandException ex) {
            return false;
        }
    }

    private int registerToDAS() throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "create-instance");
        if (this.clusterName != null) {
            argsList.add("--cluster");
            argsList.add(this.clusterName);
        }
        if (this.configName != null) {
            argsList.add("--config");
            argsList.add(this.configName);
        }
        if (this.nodeAgent != null) {
            argsList.add("--nodeagent");
            argsList.add(this.nodeAgent);
        }
        if (this.systemProperties != null) {
            argsList.add("--systemproperties");
            argsList.add(this.systemProperties);
        }
        argsList.add("--properties");
        argsList.add("rendezvousOccurred=true");
        argsList.add(this.instanceName);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("create-instance", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private boolean isRegisteredToDAS() {
        boolean isRegistered = false;
        try {
            RemoteCommand rc = new RemoteCommand("get", this.programOpts, this.env);
            int exitCode = rc.execute(new String[]{"get", this.INSTANCE_DOTTED_NAME});
            if (exitCode == 0) {
                isRegistered = true;
            }
        }
        catch (CommandException ex) {
            logger.printDebugMessage("asadmin get " + this.INSTANCE_DOTTED_NAME + " failed.");
            logger.printDebugMessage(this.instanceName + " may not be registered yet to DAS.");
        }
        return isRegistered;
    }

    private boolean rendezvousOccurred() {
        boolean rendezvousOccurred = false;
        RemoteCommand rc = null;
        try {
            rc = new RemoteCommand("get", this.programOpts, this.env);
            Map map = rc.executeAndReturnAttributes(new String[]{"get", this.RENDEZVOUS_DOTTED_NAME});
            String output = (String)map.get("children");
            String val = output.substring(output.indexOf("=") + 1);
            rendezvousOccurred = Boolean.parseBoolean(val);
            if (CLILogger.isDebug()) {
                logger.printDebugMessage("rendezvousOccurred = " + val + " for instance " + this.instanceName);
            }
        }
        catch (CommandException ce) {
            logger.printDebugMessage("Remote command failed:");
            if (rc != null) {
                logger.printDebugMessage(rc.toString());
            }
            logger.printDebugMessage("rendezvousOccurred property may not be set yet on instance " + this.instanceName);
            if (ce.getLocalizedMessage() != null) {
                logger.printDebugMessage(ce.getLocalizedMessage());
            }
            logger.printExceptionStackTrace((Throwable)ce);
        }
        return rendezvousOccurred;
    }

    private int setRendezvousOccurred(String rendezVal) throws CommandException {
        String dottedName = this.RENDEZVOUS_DOTTED_NAME + "=" + rendezVal;
        RemoteCommand rc = new RemoteCommand("set", this.programOpts, this.env);
        if (CLILogger.isDebug()) {
            logger.printDebugMessage("Setting rendezvousOccurred to " + rendezVal + " for instance " + this.instanceName);
            logger.printDebugMessage(rc.toString());
        }
        return rc.execute(new String[]{"set", dottedName});
    }
}

