/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="copy-config")
@Scoped(value=PerLookup.class)
public final class CopyConfigCommand
implements AdminCommand {
    @Param(name="srcconfig", primary=true)
    private String srcConfig;
    @Param(name="destconfig")
    private String destConfig;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CopyConfigCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Config config = this.domain.getConfigNamed(this.srcConfig);
        if (config == null) {
            report.setMessage(localStrings.getLocalString("Config.noSuchConfig", "Config {0} does not exist.", new Object[]{this.srcConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Config destinationConfig = this.domain.getConfigNamed(this.destConfig);
        if (destinationConfig != null) {
            report.setMessage(localStrings.getLocalString("Config.configExists", "Config {0} already exists.", new Object[]{this.destConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final Config destCopy = (Config)config.deepCopy();
        final String configName = this.destConfig;
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy[] w) throws PropertyVetoException, TransactionFailure {
                    ((Configs)w[0]).getConfig().add(destCopy);
                    ((Config)w[1]).setName(configName);
                    return null;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.domain.getConfigs(), destCopy});
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("Config.copyConfigError", "CopyConfig error") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

