/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-local-instance")
@Scoped(value=PerLookup.class)
public class StopLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String userArgInstanceName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopLocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.userArgInstanceName;
        super.validate();
    }

    protected boolean mkdirs(File f) {
        return false;
    }

    protected void initInstance() throws CommandException {
        super.initInstance();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File serverDir = this.getServerDirs().getServerDir();
        if (serverDir == null || !serverDir.isDirectory()) {
            return this.noSuchInstance();
        }
        if (this.getServerDirs().getLocalPassword() == null) {
            return this.instanceNotRunning();
        }
        String serverName = this.getServerDirs().getServerName();
        int adminPort = this.getAdminPort(serverName);
        this.programOpts.setPort(adminPort);
        logger.printDebugMessage("StopInstance.stoppingMessage" + adminPort);
        this.programOpts.setInteractive(false);
        if (!this.isThisServer(serverDir, "Instance-Root_value")) {
            return this.instanceNotRunning();
        }
        logger.printDebugMessage("It's the correct Instance");
        return this.doRemoteCommand();
    }

    private int instanceNotRunning() {
        logger.printWarning(strings.get("StopInstance.instanceNotRunning"));
        return 0;
    }

    private int noSuchInstance() {
        logger.printWarning(strings.get("StopInstance.noSuchInstance"));
        return 0;
    }

    private final int doRemoteCommand() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand("stop-instance", this.programOpts, this.env);
        cmd.executeAndReturnOutput(new String[]{"stop-instance"});
        this.waitForDeath();
        return 0;
    }

    private void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(strings.get("StopInstance.waitForDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(strings.get("StopInstance.instanceNotDead", new Object[]{60}));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }
}

