/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.cluster.InstanceCommandExecutor;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="GlassFishClusterExecutor")
public class GlassFishClusterExecutor
implements ClusterExecutor {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment serverEnv;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GlassFishClusterExecutor.class);

    public ActionReport.ExitCode execute(String commandName, AdminCommand command, AdminCommandContext context, ParameterMap parameters) {
        String targetName = (String)parameters.getOne((Object)"target");
        if (this.serverEnv.isDas() && targetName != null) {
            Target target = (Target)this.habitat.getComponent(Target.class);
            List instancesForReplication = target.getInstances(targetName);
            if (instancesForReplication.size() == 0) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargets", "Unable to find instances for target {0}", new Object[]{targetName}));
                return ActionReport.ExitCode.FAILURE;
            }
            return this.replicateCommand(commandName, instancesForReplication, context, parameters);
        }
        return ActionReport.ExitCode.SUCCESS;
    }

    private ActionReport.ExitCode replicateCommand(String commandName, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters) {
        ActionReport.ExitCode returnValue;
        block5: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            try {
                List<InstanceCommandExecutor> execList = this.getInstanceCommandList(commandName, instancesForReplication, context.getLogger());
                for (InstanceCommandExecutor rac : execList) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    try {
                        String result = rac.executeCommand(parameters);
                        aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandSuccessful", "Command " + commandName + "executed successfully on server instance " + rac.getServer().getName() + ";" + result, new Object[]{commandName, rac.getServer().getName()}));
                    }
                    catch (CommandException cmdEx) {
                        aReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command " + commandName + "failed on server instance " + rac.getServer().getName() + ":", new Object[]{commandName, rac.getServer().getName()}));
                        aReport.setFailureCause((Throwable)cmdEx);
                        if (returnValue.compareTo((Enum)ActionReport.ExitCode.SUCCESS) != 0) continue;
                        returnValue = ActionReport.ExitCode.FAILURE;
                    }
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication; Reason : " + ex.getLocalizedMessage(), new Object[]{ex.getLocalizedMessage()}));
                aReport.setFailureCause((Throwable)ex);
                context.getLogger().severe(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication; Reason : " + ex.getLocalizedMessage(), new Object[]{ex.getLocalizedMessage()}));
                if (returnValue.compareTo((Enum)ActionReport.ExitCode.SUCCESS) != 0) break block5;
                returnValue = ActionReport.ExitCode.FAILURE;
            }
        }
        return returnValue;
    }

    private List<InstanceCommandExecutor> getInstanceCommandList(String commandName, List<Server> servers, Logger logger) throws CommandException {
        ArrayList<InstanceCommandExecutor> list = new ArrayList<InstanceCommandExecutor>();
        for (Server svr : servers) {
            String host = svr.getNodeAgentRef();
            NetworkListener adminListener = this.domain.getConfigs().getConfigByName(svr.getConfigRef()).getNetworkConfig().getNetworkListener("admin-listener");
            String portStr = adminListener.getPort();
            int port = 4848;
            List sprops = svr.getSystemProperty();
            for (SystemProperty p : sprops) {
                if (!"ASADMIN_LISTENER_PORT".equals(p.getName())) continue;
                port = Integer.parseInt(p.getValue());
                break;
            }
            list.add(new InstanceCommandExecutor(commandName, svr, host, port, logger));
        }
        return list;
    }
}

