/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshConnector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.jvnet.hk2.component.Habitat;

public class RemoteConnectHelper {
    private Habitat habitat;
    private HashMap<String, Node> nodeMap;
    private Logger logger;

    public RemoteConnectHelper(Habitat habitat, Node[] nodes, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
        this.nodeMap = new HashMap();
        for (int i = 0; i < nodes.length; ++i) {
            Node n = nodes[i];
            this.nodeMap.put(n.getName(), n);
        }
    }

    public boolean isRemoteConnectRequired(String nodeRef) {
        Node node = this.nodeMap.get(nodeRef);
        if (node != null) {
            SshConnector sshC = node.getSshConnector();
            return sshC != null;
        }
        this.logger.warning("invalid node ref " + nodeRef);
        return false;
    }

    public int runCommand(String noderef, String cmd, String instanceName) {
        try {
            Node node = this.nodeMap.get(noderef);
            if (node == null) {
                this.logger.severe("remote.connect.noSuchNodeRef" + noderef);
                return 0;
            }
            String nodeHome = node.getNodeHome();
            if (nodeHome == null) {
                this.logger.severe("remote.connect.noNodeHome" + noderef);
                return 0;
            }
            SshConnector connector = node.getSshConnector();
            if (connector != null) {
                SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
                sshL.init(noderef);
                String command = cmd + " " + instanceName;
                String prefix = nodeHome + "/bin/asadmin ";
                String fullCommand = prefix + command;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                sshL.runCommand(fullCommand, outStream);
                String results = outStream.toString();
                if (results.endsWith("successfully.")) {
                    return 1;
                }
                return 0;
            }
        }
        catch (IOException ex) {
            this.logger.severe("remote.connect.ioexception" + cmd);
        }
        catch (InterruptedException ei) {
            this.logger.severe("remote.connect.interrupt" + cmd);
        }
        return 0;
    }
}

