/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.MemberNotInViewException;
import com.sun.enterprise.ee.cms.impl.base.EventPacket;
import com.sun.enterprise.ee.cms.impl.base.GMSContextImpl;
import com.sun.enterprise.ee.cms.impl.base.MessagePacket;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.ee.cms.spi.GroupCommunicationProvider;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import com.sun.enterprise.mgmt.ClusterManager;
import com.sun.enterprise.mgmt.ClusterMessageListener;
import com.sun.enterprise.mgmt.ClusterView;
import com.sun.enterprise.mgmt.ClusterViewEvent;
import com.sun.enterprise.mgmt.ClusterViewEventListener;
import com.sun.enterprise.mgmt.HealthMonitor;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroupCommunicationProviderImpl
implements GroupCommunicationProvider,
ClusterViewEventListener,
ClusterMessageListener {
    private ClusterManager clusterManager;
    private final String groupName;
    private GMSContextImpl ctx;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private Map<PeerID, CallableMessageSend> instanceCache = new Hashtable<PeerID, CallableMessageSend>();
    private ArrayBlockingQueue<MessagePacket> msgQueue = null;

    public GroupCommunicationProviderImpl(String groupName) {
        this.groupName = groupName;
        System.setProperty("JXTA_MGMT_LOGGER", this.logger.getName());
    }

    private GMSContextImpl getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContextImpl)GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    @Override
    public void clusterViewEvent(ClusterViewEvent clusterViewEvent, ClusterView clusterView) {
        if (!this.getGMSContext().isShuttingDown()) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Received Cluster View Event..." + clusterViewEvent.getEvent().toString() + " from " + clusterViewEvent.getAdvertisement().getName() + " view:" + clusterView.getView().toString());
            }
            EventPacket ePacket = new EventPacket(clusterViewEvent.getEvent(), clusterViewEvent.getAdvertisement(), clusterView);
            ArrayBlockingQueue<EventPacket> viewQueue = this.getGMSContext().getViewQueue();
            try {
                int remainingCapacity = viewQueue.remainingCapacity();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Adding " + (Object)((Object)clusterViewEvent.getEvent()) + " to viewQueue[size:" + viewQueue.size() + " remaining:" + viewQueue.remainingCapacity() + " ]" + "  for group:" + this.groupName);
                }
                if (remainingCapacity < 2) {
                    this.logger.warning("viewQueue for group: " + this.groupName + " near capacity, remaining capacity is" + remainingCapacity);
                }
                viewQueue.put(ePacket);
                this.logger.log(Level.FINER, "Added " + (Object)((Object)clusterViewEvent.getEvent()) + " to viewQueue for group: " + this.groupName);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "interruptedexception.occurred", new Object[]{e.getLocalizedMessage()});
            }
        }
    }

    @Override
    public void initializeGroupCommunicationProvider(String memberName, String groupName, Map<String, String> identityMap, Map configProperties) {
        ArrayList<ClusterViewEventListener> cvListeners = new ArrayList<ClusterViewEventListener>();
        if (!this.getGMSContext().isWatchdog()) {
            cvListeners.add(this);
        }
        ArrayList<ClusterMessageListener> cmListeners = new ArrayList<ClusterMessageListener>();
        cmListeners.add(this);
        this.clusterManager = new ClusterManager(groupName, memberName, identityMap, configProperties, cvListeners, cmListeners);
    }

    @Override
    public void join() {
        this.logger.log(Level.INFO, "starting cluster " + this.clusterManager.getGroupName() + " for member:" + this.clusterManager.getInstanceName());
        this.clusterManager.start();
    }

    @Override
    public void announceClusterShutdown(GMSMessage gmsMessage) {
        try {
            boolean sent = this.clusterManager.send(null, gmsMessage);
            if (!sent) {
                this.logger.warning("failed to send announceClusterShutdown to group.  gmsMessage=" + gmsMessage);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "ioexception.occurred.cluster.shutdown", new Object[]{e});
        }
        catch (MemberNotInViewException memberNotInViewException) {
            // empty catch block
        }
    }

    @Override
    public void announceGroupStartup(String groupName, GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        this.clusterManager.groupStartup(startupState, memberTokens);
    }

    @Override
    public void leave(boolean isClusterShutdown) {
        this.clusterManager.stop(isClusterShutdown);
    }

    @Override
    public void sendMessage(String targetMemberIdentityToken, Serializable message, boolean synchronous) throws GMSException, MemberNotInViewException {
        block17: {
            boolean sent = false;
            try {
                if (targetMemberIdentityToken == null) {
                    if (synchronous) {
                        List<SystemAdvertisement> currentMemberAdvs = this.clusterManager.getClusterViewManager().getLocalView().getView();
                        for (SystemAdvertisement currentMemberAdv : currentMemberAdvs) {
                            long INDOUBT_INTERVAL_MS;
                            PeerID id = currentMemberAdv.getID();
                            String member = currentMemberAdv.getName();
                            MemberStates memberState = this.getMemberState(member, INDOUBT_INTERVAL_MS = this.clusterManager.getHealthMonitor().getIndoubtDuration(), 0L);
                            if (memberState == MemberStates.PEERSTOPPING || memberState == MemberStates.STOPPED || memberState == MemberStates.CLUSTERSTOPPING) {
                                if (!this.logger.isLoggable(Level.FINE)) continue;
                                this.logger.fine("skipping broadcast message " + message + " to member:" + member + " with state" + (Object)((Object)memberState));
                                continue;
                            }
                            this.logger.log(Level.FINER, "sending message to member: " + currentMemberAdv.getName());
                            try {
                                boolean localSent = this.clusterManager.send(id, message);
                                if (localSent || !this.logger.isLoggable(Level.FINE)) continue;
                                this.logger.fine("sendMessage(synchronous=true, to=group) failed to send msg " + message + " to member " + id);
                            }
                            catch (MemberNotInViewException e) {
                                if (!this.logger.isLoggable(Level.FINE)) continue;
                                this.logger.fine("MemberNotInViewException during synchronous broadcast: " + e.toString());
                            }
                            catch (MessageIOException mioe) {
                                throw new GMSException("message not sent", mioe);
                            }
                            catch (IOException ioe) {
                                if (!this.logger.isLoggable(Level.FINE)) continue;
                                this.logger.log(Level.FINE, "IOException in reliable synchronous ptp multicast sending to instance " + currentMemberAdv.getName() + ". Perhaps this instance has failed but that has not been detected yet. Peer id=" + id.toString(), ioe);
                            }
                            catch (Throwable t) {
                                if (!this.logger.isLoggable(Level.FINE)) continue;
                                this.logger.log(Level.FINE, "Exception in reliable synchronous ptp multicast sending to instance " + currentMemberAdv.getName() + ", peer id=" + id.toString(), t);
                            }
                        }
                    } else {
                        sent = this.clusterManager.send(null, message);
                        if (!sent) {
                            throw new GMSException("message " + message + " not sent to group, send returned false");
                        }
                    }
                    break block17;
                }
                PeerID id = this.clusterManager.getID(targetMemberIdentityToken);
                if (id.equals(PeerID.NULL_PEER_ID)) {
                    this.logger.log(Level.WARNING, "GroupCommunicationProvider.sendMessage(target=" + targetMemberIdentityToken + "): unable to send message: missing mapping from member identifier to network peerid");
                    throw new MemberNotInViewException("No mapping from member identifier:" + targetMemberIdentityToken + " to a network peerid.");
                }
                if (this.clusterManager.getClusterViewManager().containsKey(id)) {
                    this.logger.log(Level.FINE, "sending message to PeerID: " + id);
                    sent = this.clusterManager.send(id, message);
                    if (!sent) {
                        throw new GMSException("message " + message + " not sent to " + id + ", send returned false");
                    }
                    break block17;
                }
                this.logger.log(Level.FINE, "message not sent to  " + targetMemberIdentityToken + " since it is not in the View");
                throw new MemberNotInViewException("Member " + targetMemberIdentityToken + " with network peerid:" + id + " is not in the View anymore. Hence not performing sendMessage operation");
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "exception in sendMessage", e);
                }
                throw new GMSException(e);
            }
        }
    }

    @Override
    public void sendMessage(Serializable message) throws GMSException, MemberNotInViewException {
        this.sendMessage(null, message, false);
    }

    public Object getLocalAddress() {
        return this.clusterManager.getSystemAdvertisement().getID();
    }

    @Override
    public List<String> getMembers() {
        return this.clusterManager.getClusterViewManager().getLocalView().getPeerNamesInView();
    }

    @Override
    public boolean isGroupLeader() {
        return this.clusterManager.isMaster();
    }

    @Override
    public MemberStates getMemberState(String member, long threshold, long timeout) {
        String state = this.clusterManager.getNodeState(this.clusterManager.getID(member), threshold, timeout).toUpperCase();
        return MemberStates.valueOf(state);
    }

    @Override
    public MemberStates getMemberState(String memberIdentityToken) {
        String state = this.clusterManager.getNodeState(this.clusterManager.getID(memberIdentityToken), 0L, 0L).toUpperCase();
        return MemberStates.valueOf(state);
    }

    @Override
    public String getGroupLeader() {
        return this.clusterManager.getClusterViewManager().getMaster().getName();
    }

    private ArrayBlockingQueue<MessagePacket> getMsgQueue() {
        if (this.msgQueue == null) {
            this.msgQueue = this.getGMSContext().getMessageQueue();
        }
        return this.msgQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClusterMessage(SystemAdvertisement adv, Object message) {
        block6: {
            MessagePacket msgPkt = new MessagePacket(adv, message);
            try {
                boolean result = this.getMsgQueue().offer(msgPkt);
                if (result) break block6;
                int fullcapacity = this.getMsgQueue().size();
                long starttime = System.currentTimeMillis();
                try {
                    this.getMsgQueue().put(msgPkt);
                }
                finally {
                    long duration = System.currentTimeMillis() - starttime;
                    if (duration > 0L) {
                        this.monitorLogger.info("remote message reception blocked due to incoming message queue being full for " + duration + " ms. Message queue capacity: " + fullcapacity);
                    }
                }
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, MessageFormat.format("Interrupted Exception occured while adding message to Shoal MessageQueue :{0}", e.getLocalizedMessage()));
            }
        }
    }

    @Override
    public void assumeGroupLeadership() {
        this.clusterManager.takeOverMasterRole();
    }

    @Override
    public void setGroupStoppingState() {
        this.clusterManager.setClusterStopping();
    }

    @Override
    public void reportJoinedAndReadyState() {
        this.clusterManager.reportJoinedAndReadyState();
    }

    @Override
    public void announceWatchdogObservedFailure(String serverToken) throws GMSException {
        if (this.clusterManager == null) {
            this.logger.severe("cluster manager unexpectedly null");
            return;
        }
        HealthMonitor hm = this.clusterManager.getHealthMonitor();
        if (hm == null) {
            this.logger.severe("clusterManager.getHealthMonitor() unexpectedly null");
            return;
        }
        hm.announceWatchdogObservedFailure(serverToken);
    }

    @Override
    public boolean isDiscoveryInProgress() {
        return this.clusterManager.isDiscoveryInProgress();
    }

    private class CallableMessageSend
    implements Callable<Object> {
        private PeerID member;
        private Serializable msg;

        private CallableMessageSend(PeerID member) {
            this.member = member;
        }

        public void setMessage(Serializable msg) {
            this.msg = null;
            this.msg = msg;
        }

        @Override
        public Object call() throws Exception {
            boolean sent = GroupCommunicationProviderImpl.this.clusterManager.send(this.member, this.msg);
            if (!sent && GroupCommunicationProviderImpl.this.logger.isLoggable(Level.FINE)) {
                GroupCommunicationProviderImpl.this.logger.fine("CallableMessageSend failed to send msg " + this.msg + " to member " + this.member);
            }
            return null;
        }
    }
}

