/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-instance")
@I18n(value="create.instance")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class CreateInstanceCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodes;
    @Param(name="node", optional=true)
    String node;
    @Param(name="nodeagent")
    String nodeAgent;
    @Param(name="config", optional=true)
    String configRef;
    @Param(name="cluster", optional=true)
    String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger;
    private AdminCommandContext ctx;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_register-instance", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"node", (Object)this.node);
        map.add((Object)"nodeagent", (Object)this.nodeAgent);
        map.add((Object)"config", (Object)this.configRef);
        map.add((Object)"cluster", (Object)this.clusterName);
        map.add((Object)"systemproperties", (Object)this.systemProperties);
        map.add((Object)"DEFAULT", (Object)this.instance);
        ci.parameters(map);
        ci.execute();
        if (this.node.equals("localhost")) {
            LocalAdminCommand lac = new LocalAdminCommand("_create-instance-filesystem", new String[]{this.instance});
            try {
                int status = lac.execute();
            }
            catch (ProcessManagerException ex) {
                String msg = Strings.get("create.instance.failed", this.instance);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
            }
        } else {
            this.createInstanceRemote();
        }
    }

    private void createInstanceRemote() {
        int status;
        RemoteConnectHelper rch = new RemoteConnectHelper(this.habitat, this.nodes, this.logger);
        if (rch.isRemoteConnectRequired(this.node) && (status = rch.runCommand(this.node, "_create-instance-filesystem", this.instance)) != 1) {
            ActionReport report = this.ctx.getActionReport();
            String msg = Strings.get("create.instance.failed", this.instance);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }
}

