/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.cluster.InstanceCommandExecutor;
import com.sun.grizzly.config.dom.NetworkListener;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.config.support.CommandTarget;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="GlassFishClusterExecutor")
public class GlassFishClusterExecutor
implements ClusterExecutor {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private Habitat habitat;
    @Inject(name="default-instance-name")
    protected Server server;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GlassFishClusterExecutor.class);

    public ActionReport.ExitCode execute(String commandName, AdminCommand command, AdminCommandContext context, ParameterMap parameters) {
        CommandModel model;
        try {
            CommandModelProvider c = (CommandModelProvider)command;
            model = c.getModel();
        }
        catch (ClassCastException e) {
            model = new CommandModelImpl(command.getClass());
        }
        Cluster clAnnotation = model.getClusteringAttributes();
        String targetName = (String)parameters.getOne((Object)"target");
        if (targetName != null && !CommandTarget.DAS.isValid(this.habitat, targetName) && !CommandTarget.DOMAIN.isValid(this.habitat, targetName)) {
            Target target = (Target)this.habitat.getComponent(Target.class);
            List instancesForReplication = target.getInstances(targetName);
            if (instancesForReplication.size() == 0) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargets", "Did not find any suitable instances for target {0}; command executed on DAS only", new Object[]{targetName}));
                return ActionReport.ExitCode.SUCCESS;
            }
            return this.replicateCommand(commandName, clAnnotation == null ? FailurePolicy.Error : clAnnotation.ifFailure(), clAnnotation == null ? FailurePolicy.Warn : clAnnotation.ifOffline(), instancesForReplication, context, parameters);
        }
        return ActionReport.ExitCode.SUCCESS;
    }

    private ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters) {
        ActionReport.ExitCode returnValue;
        block10: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            try {
                List<InstanceCommandExecutor> execList = this.getInstanceCommandList(commandName, instancesForReplication, context.getLogger());
                for (InstanceCommandExecutor rac : execList) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    try {
                        rac.executeCommand(parameters);
                        aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandSuccessful", "Command {0} executed successfully on server instance {1}", new Object[]{commandName, rac.getServer().getName()}));
                    }
                    catch (CommandException cmdEx) {
                        ActionReport.ExitCode finalResult;
                        if (cmdEx.getCause() instanceof ConnectException) {
                            finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)offlinePolicy, (ActionReport.ExitCode)ActionReport.ExitCode.WARNING);
                            if (!finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.warnoffline", "WARNING : Instance {0} seems to be offline; Command was not replicated to that instance", new Object[]{rac.getServer().getName()}));
                            }
                        } else {
                            finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                            if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command {0} failed on server instance {1} : {2}", new Object[]{commandName, rac.getServer().getName(), cmdEx.getMessage()}));
                            } else {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandWanring", "WARNING : Command {0} did not complete successfully on server instance {1} : {2}", new Object[]{commandName, rac.getServer().getName(), cmdEx.getMessage()}));
                            }
                        }
                        aReport.setActionExitCode(finalResult);
                        if (!returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                        returnValue = finalResult;
                    }
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                ActionReport.ExitCode finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                aReport.setActionExitCode(finalResult);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication : {0}", new Object[]{ex.getMessage()}));
                context.getLogger().severe("Error during command replication; Reason : " + ex.getLocalizedMessage());
                if (!returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) break block10;
                returnValue = finalResult;
            }
        }
        return returnValue;
    }

    private List<InstanceCommandExecutor> getInstanceCommandList(String commandName, List<Server> servers, Logger logger) throws CommandException {
        ArrayList<InstanceCommandExecutor> list = new ArrayList<InstanceCommandExecutor>();
        for (Server svr : servers) {
            String host = svr.getNodeAgentRef();
            NetworkListener adminListener = this.domain.getConfigs().getConfigByName(svr.getConfigRef()).getNetworkConfig().getNetworkListener("admin-listener");
            String portStr = adminListener.getPort();
            int port = 4848;
            List sprops = svr.getSystemProperty();
            for (SystemProperty p : sprops) {
                if (!"ASADMIN_LISTENER_PORT".equals(p.getName())) continue;
                port = Integer.parseInt(p.getValue());
                break;
            }
            list.add(new InstanceCommandExecutor(commandName, svr, host, port, logger));
        }
        return list;
    }
}

