/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="start-instance")
@Scoped(value=PerLookup.class)
@I18n(value="start.instance.command")
public class StartInstanceCommand
implements AdminCommand,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodes;
    @Inject
    private CommandRunner cr;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers servers;
    @Inject
    private Configs configs;
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(optional=true, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private HashMap<String, Node> nodeMap;
    private AdminCommandContext ctx;
    private String noderef;

    public void execute(AdminCommandContext context) {
        this.logger = context.getLogger();
        this.ctx = context;
        if (!StringUtils.ok((String)this.instanceName)) {
            this.logger.severe(Strings.get("start.instance.noInstanceName"));
            return;
        }
        Server instance = this.helper.getServer(this.instanceName);
        if (instance == null) {
            this.logger.severe(Strings.get("start.instance.noSuchInstance", this.instanceName));
            return;
        }
        this.noderef = this.helper.getNode(instance);
        if (this.noderef.equals("noNodeRef")) {
            this.logger.severe(Strings.get("start.instance.noSuchNodeRef", this.noderef));
            return;
        }
        if (this.env.isDas()) {
            this.callInstance();
        } else if (this.env.isInstance()) {
            this.startInstance();
        } else {
            String msg = Strings.get("start.instance.notAnInstanceOrDas", this.env.getRuntimeType().toString());
            this.logger.warning(msg);
        }
    }

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.env, this.servers, this.configs);
    }

    private void startInstance() {
        LocalAdminCommand lac = new LocalAdminCommand("start-local-instance", new String[]{this.instanceName});
        try {
            int status = lac.execute();
        }
        catch (ProcessManagerException processManagerException) {
            // empty catch block
        }
    }

    private void callInstance() {
        if (this.noderef.equals("localhost")) {
            this.startInstance();
        } else {
            int status;
            RemoteConnectHelper rch = new RemoteConnectHelper(this.habitat, this.nodes, this.logger);
            if (rch.isRemoteConnectRequired(this.noderef) && (status = rch.runCommand(this.noderef, "start-local-instance", this.instanceName)) != 1) {
                ActionReport report = this.ctx.getActionReport();
                String msg = Strings.get("start.instance.failed", this.instanceName);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
            }
        }
    }
}

