/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.InjectionResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="SupplementalCommandExecutorImpl")
public class SupplementalCommandExecutorImpl
implements SupplementalCommandExecutor {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment serverEnv;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SupplementalCommandExecutor.class);
    private Map<String, List<SupplementalCommand>> supplementalCommandsMap = null;

    public ActionReport.ExitCode execute(String commandName, Supplemental.Timing time, AdminCommandContext context, InjectionResolver<Param> injector) {
        ActionReport.ExitCode finalResult = ActionReport.ExitCode.SUCCESS;
        if (!this.getSupplementalCommandsList().isEmpty() && this.getSupplementalCommandsList().containsKey(commandName)) {
            List<SupplementalCommand> cmds = this.getSupplementalCommandsList().get(commandName);
            for (SupplementalCommand aCmd : cmds) {
                if ((!this.serverEnv.isDas() || !aCmd.whereToRun().contains(RuntimeType.DAS)) && (!this.serverEnv.isInstance() || !aCmd.whereToRun().contains(RuntimeType.INSTANCE)) || (!time.equals((Object)Supplemental.Timing.Before) || !aCmd.toBeExecutedBefore()) && (!time.equals((Object)Supplemental.Timing.After) || !aCmd.toBeExecutedAfter())) continue;
                ActionReport.ExitCode result = FailurePolicy.applyFailurePolicy((FailurePolicy)aCmd.onFailure(), (ActionReport.ExitCode)this.inject(aCmd, injector, context.getActionReport()));
                if (!result.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    if (!finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                    finalResult = result;
                    continue;
                }
                aCmd.execute(context);
                if (context.getActionReport().hasFailures()) {
                    result = FailurePolicy.applyFailurePolicy((FailurePolicy)aCmd.onFailure(), (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                } else if (context.getActionReport().hasWarnings()) {
                    result = FailurePolicy.applyFailurePolicy((FailurePolicy)aCmd.onFailure(), (ActionReport.ExitCode)ActionReport.ExitCode.WARNING);
                }
                if (result.equals((Object)ActionReport.ExitCode.SUCCESS) || !finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                finalResult = result;
            }
        }
        return finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<SupplementalCommand>> getSupplementalCommandsList() {
        if (this.supplementalCommandsMap == null) {
            SupplementalCommandExecutorImpl supplementalCommandExecutorImpl = this;
            synchronized (supplementalCommandExecutorImpl) {
                if (this.supplementalCommandsMap == null) {
                    this.supplementalCommandsMap = new ConcurrentHashMap<String, List<SupplementalCommand>>();
                    Collection supplementals = this.habitat.getInhabitants(Supplemental.class);
                    if (!supplementals.isEmpty()) {
                        for (Inhabitant inh : supplementals) {
                            MultiMap map = inh.metadata();
                            String commandName = (String)map.getOne((Object)"target");
                            AdminCommand cmdObject = (AdminCommand)inh.get();
                            Supplemental ann = cmdObject.getClass().getAnnotation(Supplemental.class);
                            SupplementalCommand cmd = new SupplementalCommand(cmdObject, ann.on(), ann.ifFailure());
                            if (this.supplementalCommandsMap.containsKey(commandName)) {
                                this.supplementalCommandsMap.get(commandName).add(cmd);
                                continue;
                            }
                            ArrayList<SupplementalCommand> cmdList = new ArrayList<SupplementalCommand>();
                            cmdList.add(cmd);
                            this.supplementalCommandsMap.put(commandName, cmdList);
                        }
                    }
                }
            }
        }
        return this.supplementalCommandsMap;
    }

    private ActionReport.ExitCode inject(SupplementalCommand cmd, InjectionResolver<Param> injector, ActionReport subActionReport) {
        ActionReport.ExitCode result = ActionReport.ExitCode.SUCCESS;
        try {
            new InjectionManager().inject((Object)cmd.command, new InjectionResolver[]{injector});
        }
        catch (Exception e) {
            result = ActionReport.ExitCode.FAILURE;
            subActionReport.setActionExitCode(result);
            subActionReport.setMessage(e.getMessage());
            subActionReport.setFailureCause((Throwable)e);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupplementalCommand {
        private AdminCommand command;
        private Supplemental.Timing timing;
        private FailurePolicy failurePolicy;
        private List<RuntimeType> whereToRun = new ArrayList<RuntimeType>();

        public SupplementalCommand(AdminCommand cmd, Supplemental.Timing time, FailurePolicy onFail) {
            this.command = cmd;
            this.timing = time;
            this.failurePolicy = onFail;
            Cluster ann = cmd.getClass().getAnnotation(Cluster.class);
            if (ann == null) {
                this.whereToRun.add(RuntimeType.DAS);
                this.whereToRun.add(RuntimeType.INSTANCE);
            } else if (ann.value().length == 0) {
                this.whereToRun.add(RuntimeType.DAS);
                this.whereToRun.add(RuntimeType.INSTANCE);
            } else {
                for (RuntimeType t : ann.value()) {
                    this.whereToRun.add(t);
                }
            }
        }

        public void execute(AdminCommandContext ctxt) {
            this.command.execute(ctxt);
        }

        public boolean toBeExecutedBefore() {
            return this.timing.equals((Object)Supplemental.Timing.Before);
        }

        public boolean toBeExecutedAfter() {
            return this.timing.equals((Object)Supplemental.Timing.After);
        }

        public FailurePolicy onFailure() {
            return this.failurePolicy;
        }

        public List<RuntimeType> whereToRun() {
            return this.whereToRun;
        }
    }
}

