/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.logging.LogDomains;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.types.Property;

@Service
public class GMSAdapterImpl
implements GMSAdapter,
PostConstruct,
CallBack {
    private static final Logger logger = LogDomains.getLogger(GMSAdapterImpl.class, (String)"javax.org.glassfish.gms");
    private GroupManagementService gms;
    private static final String INSTANCE_NAME = "INSTANCE_NAME";
    private static final String CLUSTER_NAME = "CLUSTER_NAME";
    private static final String CORE = "CORE";
    private static final String SPECTATOR = "SPECTATOR";
    private static final String MEMBERTYPE_STRING = "MEMBER_TYPE";
    private String instanceName = null;
    private boolean isDas = false;
    private Cluster cluster = null;
    private String clusterName = null;
    private Config clusterConfig = null;
    @Inject
    Events events;
    @Inject
    ServerEnvironment env;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    Habitat habitat;

    public void postConstruct() {
        logger.setLevel(Level.CONFIG);
        logger.log(Level.CONFIG, "gmsservice.postconstruct");
        Domain domain = (Domain)this.habitat.getComponent(Domain.class);
        this.instanceName = this.env.getInstanceName();
        this.isDas = this.env.isDas();
        this.cluster = this.isDas ? (Cluster)domain.getClusters().getCluster().get(0) : this.server.getCluster();
        if (this.cluster == null) {
            logger.log(Level.WARNING, "gmsservice.nocluster.warning");
            return;
        }
        this.clusterName = this.cluster.getName();
        this.clusterConfig = domain.getConfigNamed(this.clusterName + "-config");
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("clusterName=" + this.clusterName);
            logger.config("clusterConfig=" + this.clusterConfig);
            logger.config("domaing.getConfigs()=" + domain.getConfigs());
        }
        try {
            this.initializeGMS();
        }
        catch (GMSException e) {
            logger.log(Level.WARNING, "gmsexception.occurred", e.getLocalizedMessage());
        }
    }

    private void initStopGapGMSConfiguration(Properties configProps) {
        this.getSystemProps(configProps);
        this.readFromPropsFile(configProps);
        Enumeration<?> property = configProps.propertyNames();
        while (property.hasMoreElements()) {
            String key = (String)property.nextElement();
            String value = configProps.getProperty(key);
            if (value == null) continue;
            configProps.setProperty(key.trim(), value.trim());
        }
    }

    private void readGMSConfigProps(Properties configProps) {
        GrizzlyConfigConstants key;
        String value;
        String name;
        configProps.put(MEMBERTYPE_STRING, this.isDas ? SPECTATOR : CORE);
        block22: for (ServiceProviderConfigurationKeys key2 : ServiceProviderConfigurationKeys.values()) {
            String keyName = key2.toString();
            try {
                switch (key2) {
                    case MULTICASTADDRESS: {
                        if (this.cluster == null) break;
                        configProps.put(keyName, this.cluster.getGmsMulticastAddress());
                        break;
                    }
                    case MULTICASTPORT: {
                        if (this.cluster == null) break;
                        configProps.put(keyName, this.cluster.getGmsMulticastPort());
                        break;
                    }
                    case FAILURE_DETECTION_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getHeartbeatFrequencyInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_RETRIES: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getMaxMissedHeartbeats();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_VERIFICATION_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureWaittimeInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case DISCOVERY_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getGroupDiscoveryTimeoutInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case IS_BOOTSTRAPPING_NODE: {
                        configProps.put(keyName, this.isDas ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        break;
                    }
                    case VIRTUAL_MULTICAST_URI_LIST: {
                        break;
                    }
                    case BIND_INTERFACE_ADDRESS: {
                        if (this.cluster == null) break;
                        String value2 = this.cluster.getGmsBindInterfaceAddress().trim();
                        if (value2 == null || value2.length() <= 1 || value2.charAt(0) == '$') continue block22;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureConnectTimeoutInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case MULTICAST_POOLSIZE: 
                    case INCOMING_MESSAGE_QUEUE_SIZE: 
                    case FAILURE_DETECTION_TCP_RETRANSMIT_PORT: {
                        if (this.clusterConfig == null) break;
                        Property prop = this.clusterConfig.getGroupManagementService().getProperty(keyName);
                        String value3 = prop.getValue().trim();
                        int positiveint = 0;
                        try {
                            positiveint = Integer.getInteger(value3);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (positiveint <= 0) continue block22;
                        configProps.put(keyName, (Object)positiveint);
                        break;
                    }
                    case LOOPBACK: {
                        break;
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        List props = null;
        if (this.clusterConfig != null) {
            props = this.clusterConfig.getGroupManagementService().getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                logger.config("processing group-management-service property name=" + name + " value= " + value);
                if (name == null) continue;
                try {
                    key = GrizzlyConfigConstants.valueOf((String)name);
                    configProps.put(name, value);
                }
                catch (IllegalArgumentException iae) {}
            }
        }
        if (this.cluster != null) {
            props = this.cluster.getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                logger.config("processing cluster property name=" + name + " value= " + value);
                if (name == null) continue;
                try {
                    key = GrizzlyConfigConstants.valueOf((String)name);
                    configProps.put(name, value);
                }
                catch (IllegalArgumentException iae) {}
            }
        }
    }

    private void initializeGMS() throws GMSException {
        Properties configProps = new Properties();
        this.initStopGapGMSConfiguration(configProps);
        this.printProps(configProps);
        String memberType = (String)configProps.get(MEMBERTYPE_STRING);
        this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)this.instanceName, (String)this.clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.valueOf((String)memberType), (Properties)configProps);
        if (this.gms != null) {
            try {
                this.gms.addActionFactory((JoinedAndReadyNotificationActionFactory)new JoinedAndReadyNotificationActionFactoryImpl((CallBack)this));
                this.gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl((CallBack)this));
                this.gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl((CallBack)this));
                this.gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl((CallBack)this));
                this.gms.addActionFactory((FailureSuspectedActionFactory)new FailureSuspectedActionFactoryImpl((CallBack)this));
                this.events.register(new EventListener(){

                    public void event(EventListener.Event event) {
                        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                            logger.fine("Calling gms.shutdown()...");
                            GMSAdapterImpl.this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                        } else if (event.is(EventTypes.SERVER_READY)) {
                            logger.fine("Ready");
                            GMSAdapterImpl.this.gms.reportJoinedAndReadyState(GMSAdapterImpl.this.clusterName);
                        }
                    }
                });
                this.gms.join();
            }
            catch (GMSException e) {
                logger.log(Level.WARNING, "gmsexception.occurred", e.getLocalizedMessage());
            }
        } else {
            throw new GMSException("gms object is null.");
        }
        logger.log(Level.CONFIG, "gmsservice.started ", new Object[]{this.instanceName, this.clusterName});
        logger.info(this.instanceName + " joined group " + this.clusterName);
    }

    private Properties readFromPropsFile(Properties configProps) {
        FileInputStream in;
        String INSTANCE_PROPS_FILE_LOCATION = "/clusters/" + this.clusterName + "/" + this.instanceName + ".properties";
        String CLUSTER_PROPS_FILE_LOCATION = "/clusters/" + this.clusterName + "/cluster.properties";
        String install_location = System.getProperty("com.sun.aas.installRoot");
        String fileName = install_location + INSTANCE_PROPS_FILE_LOCATION;
        logger.config("configProps file location ..." + install_location + INSTANCE_PROPS_FILE_LOCATION + "and " + install_location + CLUSTER_PROPS_FILE_LOCATION);
        try {
            in = new FileInputStream(fileName);
            configProps.load(in);
            in.close();
        }
        catch (FileNotFoundException fe) {
            logger.log(Level.WARNING, "Cannot find the properties file : " + fileName, fe.getLocalizedMessage() + "Using Shoal Defaults...");
            return configProps;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while trying to load the properties file.Using GMS default properties", ioe.getLocalizedMessage());
            return configProps;
        }
        try {
            fileName = install_location + CLUSTER_PROPS_FILE_LOCATION;
            in = new FileInputStream(fileName);
            configProps.load(in);
            in.close();
            return configProps;
        }
        catch (FileNotFoundException fe) {
            logger.log(Level.WARNING, "Cannot find the properties file : " + fileName + "Using GMS default properties", fe.getLocalizedMessage());
            return configProps;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while trying to load the properties file.Using GMS default properties", ioe.getLocalizedMessage());
            return configProps;
        }
    }

    private Properties getSystemProps(Properties configProps) {
        String bindInterfaceAddress;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Is initial host=" + System.getProperty("IS_INITIAL_HOST"));
        }
        configProps.put(INSTANCE_NAME, this.instanceName);
        configProps.put(CLUSTER_NAME, this.clusterName);
        if (this.instanceName.equals("server")) {
            configProps.put(MEMBERTYPE_STRING, SPECTATOR);
            configProps.put(ServiceProviderConfigurationKeys.IS_BOOTSTRAPPING_NODE.toString(), (Object)true);
        } else {
            configProps.put(MEMBERTYPE_STRING, System.getProperty(MEMBERTYPE_STRING, CORE).toUpperCase());
            configProps.put(ServiceProviderConfigurationKeys.IS_BOOTSTRAPPING_NODE.toString(), System.getProperty("IS_INITIAL_HOST", "false"));
        }
        configProps.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), System.getProperty("MULTICASTADDRESS", "229.9.1.1"));
        configProps.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), (Object)2299);
        if (System.getProperty("INITIAL_HOST_LIST") != null) {
            configProps.put(ServiceProviderConfigurationKeys.VIRTUAL_MULTICAST_URI_LIST.toString(), System.getProperty("INITIAL_HOST_LIST"));
        }
        configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), System.getProperty(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), "3"));
        configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TIMEOUT.toString(), System.getProperty(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TIMEOUT.toString(), "2000"));
        configProps.put(ServiceProviderConfigurationKeys.DISCOVERY_TIMEOUT.toString(), System.getProperty(ServiceProviderConfigurationKeys.DISCOVERY_TIMEOUT.toString(), "5000"));
        configProps.put(ServiceProviderConfigurationKeys.FAILURE_VERIFICATION_TIMEOUT.toString(), System.getProperty(ServiceProviderConfigurationKeys.FAILURE_VERIFICATION_TIMEOUT.toString(), "1500"));
        String timeout = System.getProperty(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT.toString());
        if (timeout != null) {
            configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT.toString(), timeout);
        }
        if ((bindInterfaceAddress = System.getProperty("BIND_INTERFACE_ADDRESS")) != null) {
            configProps.put(ServiceProviderConfigurationKeys.BIND_INTERFACE_ADDRESS.toString(), bindInterfaceAddress);
        }
        configProps.put(GrizzlyConfigConstants.TCPSTARTPORT.toString(), System.getProperty("TCPSTARTPORT", "9090"));
        configProps.put(GrizzlyConfigConstants.TCPENDPORT.toString(), System.getProperty("TCPENDPORT", "9120"));
        return configProps;
    }

    private void printProps(Properties prop) {
        if (!logger.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : prop.stringPropertyNames()) {
            sb.append(key).append(" = ").append(prop.get(key)).append("  ");
        }
        logger.log(Level.CONFIG, "gmsservice.print.properties", sb.toString());
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public GroupManagementService getGMS(String groupName) {
        try {
            return GMSFactory.getGMSModule((String)groupName);
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, "Exception in getting GMS module for group " + groupName, e.getLocalizedMessage());
            return null;
        }
    }

    public void processNotification(Signal signal) {
        logger.log(Level.INFO, "gmsservice.processNotification", signal.getClass().getName());
    }

    public GroupManagementService getModule() {
        return this.gms;
    }
}

