/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.glassfish.cluster.ssh.util.HostVerifier;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="SSHLauncher")
public class SSHLauncher
implements PostConstruct {
    private static KnownHosts knownHostsDatabase = new KnownHosts();
    private String host;
    private int port;
    private String userName;
    private String keyFile;
    private Connection connection;
    private String authType;
    @Inject
    Node[] nodes;
    private File knownHosts;
    private HashMap<String, Node> nodeMap;

    public void postConstruct() {
        this.nodeMap = new HashMap();
        for (Node node : this.nodes) {
            if (node.getSshConnector() == null) continue;
            this.nodeMap.put(node.getName(), node);
        }
    }

    public void init(String nodeName) {
        int port;
        Node node = this.nodeMap.get(nodeName);
        SshConnector connector = node.getSshConnector();
        String host = connector.getSshHost();
        this.host = SSHUtil.checkString(host) != null ? host : node.getNodeHost();
        try {
            port = Integer.parseInt(connector.getSshPort());
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        this.port = port == 0 ? 22 : port;
        String sshHost = connector.getSshHost();
        if (sshHost != null) {
            this.host = sshHost;
        }
        SshAuth sshAuth = connector.getSshAuth();
        String userName = null;
        if (sshAuth != null) {
            userName = sshAuth.getUserName();
            this.keyFile = sshAuth.getKeyfile();
        }
        String string = this.userName = SSHUtil.checkString(userName) == null ? System.getProperty("user.name") : userName;
        if (this.knownHosts == null) {
            File home = new File(System.getProperty("user.home"));
            this.knownHosts = new File(home, ".ssh/known_hosts");
        }
        if (this.knownHosts.exists()) {
            try {
                knownHostsDatabase.addHostkeys(this.knownHosts);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean openConnection() {
        boolean isAuthenticated = false;
        this.connection = new Connection(this.host, this.port);
        try {
            File key;
            this.connection.connect(new HostVerifier(knownHostsDatabase));
            String userName = this.userName;
            if (SSHUtil.checkString(this.keyFile) == null) {
                File home = new File(System.getProperty("user.home"));
                for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                    File key2 = new File(home, ".ssh/" + keyName);
                    if (key2.exists()) {
                        isAuthenticated = this.connection.authenticateWithPublicKey(userName, key2, null);
                    }
                    if (!isAuthenticated) continue;
                    break;
                }
            }
            if (!isAuthenticated && SSHUtil.checkString(this.keyFile) != null && (key = new File(this.keyFile)).exists()) {
                isAuthenticated = this.connection.authenticateWithPublicKey(userName, key, null);
            }
            if (!isAuthenticated && !this.connection.isAuthenticationComplete()) {
                this.connection.close();
                this.connection = null;
                throw new IOException("Could not authenticate");
            }
            SSHUtil.register(this.connection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isAuthenticated;
    }

    public void runCommand(String command, OutputStream os) throws IOException, InterruptedException {
        if (!this.openConnection()) {
            return;
        }
        this.connection.exec(command, os);
        SSHUtil.unregister(this.connection);
        this.connection = null;
    }
}

