/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-instances")
@I18n(value="list.instances.command")
@Scoped(value=PerLookup.class)
public class ListInstancesCommand
implements AdminCommand,
PostConstruct {
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers servers;
    @Inject
    private Configs configs;
    @Param(optional=true, defaultValue="2000")
    String timeoutmsec;
    @Param(optional=true, defaultValue="false")
    boolean standaloneonly;
    @Param(optional=true, defaultValue="false")
    boolean nostatus;
    private List<InstanceInfo> infos = new LinkedList<InstanceInfo>();
    private RemoteInstanceCommandHelper helper;
    private static final String NONE = "Nothing to list.";
    private static final String RUNNING = "running";
    private static final String NOT_RUNNING = "not running";

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.env, this.servers, this.configs);
    }

    public void execute(AdminCommandContext context) {
        int timeoutInMsec;
        try {
            timeoutInMsec = Integer.parseInt(this.timeoutmsec);
        }
        catch (Exception e) {
            timeoutInMsec = 2000;
        }
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        List serverList = this.servers.getServer();
        if (!this.helper.isDas()) {
            String msg = Strings.get("list.instances.onlyRunsOnDas");
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.nostatus) {
            this.noStatus(report, serverList);
        } else {
            this.yesStatus(report, serverList, timeoutInMsec, logger);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void noStatus(ActionReport report, List<Server> serverList) {
        if (serverList.size() < 1) {
            report.addSubActionsReport().setMessage(NONE);
        } else {
            for (Server server : serverList) {
                String name;
                boolean clustered;
                boolean bl = clustered = server.getCluster() != null;
                if (this.standaloneonly && clustered || "server".equals(name = server.getName())) continue;
                report.addSubActionsReport().setMessage(name);
            }
        }
    }

    private void yesStatus(ActionReport report, List<Server> serverList, int timeoutInMsec, Logger logger) {
        for (Server server : serverList) {
            String name;
            boolean clustered;
            boolean bl = clustered = server.getCluster() != null;
            if (this.standaloneonly && clustered || (name = server.getName()) == null || name.equals("server")) continue;
            InstanceInfo ii = new InstanceInfo(name, this.helper.getAdminPort(server), this.helper.getHost(server), logger, timeoutInMsec);
            this.infos.add(ii);
        }
        if (this.infos.size() < 1) {
            report.addSubActionsReport().setMessage(NONE);
        } else {
            for (InstanceInfo ii : this.infos) {
                String s = ii.isRunning() ? RUNNING : NOT_RUNNING;
                report.addSubActionsReport().setMessage(ii.getName() + " " + s);
            }
        }
    }
}

