/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.List;
import org.glassfish.api.admin.ServerEnvironment;

final class RemoteInstanceCommandHelper {
    private final ServerEnvironment env;
    private final List<Server> servers;
    private final List<Config> configs;

    RemoteInstanceCommandHelper(ServerEnvironment env0, Servers servers0, Configs configs0) {
        this.env = env0;
        this.configs = configs0.getConfig();
        this.servers = servers0.getServer();
    }

    final boolean isDas() {
        return this.env.isDas();
    }

    final boolean isInstance() {
        return this.env.isInstance();
    }

    final int getAdminPort(String serverName) {
        return this.getAdminPort(this.getServer(serverName));
    }

    final String getHost(String serverName) {
        return this.getHost(this.getServer(serverName));
    }

    final String getHost(Server server) {
        if (server == null) {
            return null;
        }
        String host = server.getNodeAgentRef();
        if (StringUtils.ok((String)host)) {
            return host;
        }
        return Strings.get("noNodeAgentRef");
    }

    final Server getServer(String serverName) {
        for (Server server : this.servers) {
            String name = server.getName();
            if (!(serverName == null ? name == null : serverName.equals(name))) continue;
            return server;
        }
        return null;
    }

    final String getNode(Server server) {
        if (server == null) {
            return null;
        }
        String node = server.getNode();
        if (StringUtils.ok((String)node)) {
            return node;
        }
        return Strings.get("noNodeRef");
    }

    final int getAdminPort(Server server) {
        String portString = this.getAdminPortString(server, this.getConfig(server));
        if (portString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(portString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String getAdminPortString(Server server, Config config) {
        if (server == null || config == null) {
            return null;
        }
        try {
            List listeners = config.getNetworkConfig().getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : listeners) {
                if (!"admin-listener".equals(listener.getProtocol())) continue;
                return this.translatePort(listener.getPort(), server, config);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Config getConfig(Server server) {
        if (server == null) {
            return null;
        }
        String cfgName = server.getConfigRef();
        if (cfgName == null) {
            return null;
        }
        for (Config config : this.configs) {
            if (!cfgName.equals(config.getName())) continue;
            return config;
        }
        return null;
    }

    private String translatePort(String portString, Server server, Config config) {
        if (!RemoteInstanceCommandHelper.isToken(portString)) {
            return portString;
        }
        String key = portString.substring(2, portString.length() - 1);
        SystemProperty prop = server.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        prop = config.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    private static boolean isToken(String s) {
        return s != null && s.startsWith("${") && s.endsWith("}") && s.length() > 3;
    }
}

