/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="copy-config")
@Scoped(value=PerLookup.class)
public final class CopyConfigCommand
implements AdminCommand {
    @Param(primary=true, multiple=true)
    List<String> configs;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CopyConfigCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Object spb = null;
        if (this.configs.size() != 2) {
            report.setMessage(localStrings.getLocalString("Config.badConfigNames", "You must specify a source and destination config") + "\n" + localStrings.getLocalString("Config.copyConfigUsage", "Usage copy-config \\n[--systemproperties (name=value)[:name=value]*]\\nsource_configuration_name destination_configuration_name"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String srcConfig = this.configs.get(0);
        String destConfig = this.configs.get(1);
        Config config = this.domain.getConfigNamed(srcConfig);
        if (config == null) {
            report.setMessage(localStrings.getLocalString("Config.noSuchConfig", "Config {0} does not exist.", new Object[]{srcConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Config destinationConfig = this.domain.getConfigNamed(destConfig);
        if (destinationConfig != null) {
            report.setMessage(localStrings.getLocalString("Config.configExists", "Config {0} already exists.", new Object[]{destConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final Config destCopy = (Config)config.deepCopy();
        final String configName = destConfig;
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy[] w) throws PropertyVetoException, TransactionFailure {
                    ((Configs)w[0]).getConfig().add(destCopy);
                    ((Config)w[1]).setName(configName);
                    return null;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.domain.getConfigs(), destCopy});
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("Config.copyConfigError", "CopyConfig error") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

