/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class GmsAdapterService
implements Startup,
PostConstruct {
    static final Logger logger = LogDomains.getLogger(GmsAdapterService.class, (String)"javax.enterprise.system.core");
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    GMSAdapter gmsAdapter;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        Domain domain = (Domain)this.habitat.getComponent(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters != null) {
            if (this.server.isDas()) {
                this.checkAllClusters(clusters);
            } else {
                this.checkCurrentCluster(clusters);
            }
        }
    }

    public String toString() {
        return "GMS Loader";
    }

    public GMSAdapter getGMSAdapter() {
        return this.gmsAdapter;
    }

    public boolean isGmsEnabled() {
        return this.gmsAdapter != null;
    }

    public GMSAdapter getGMSAdapterByName(String clusterName) {
        return this.gmsAdapter;
    }

    private void checkAllClusters(Clusters clusters) {
        logger.fine("In DAS. Checking all clusters.");
        for (Cluster cluster : clusters.getCluster()) {
            String gmsEnString = cluster.getGmsEnabled();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("cluster %s found with gms-enabled='%s'", cluster.getName(), gmsEnString));
            }
            if (gmsEnString == null || !Boolean.parseBoolean(gmsEnString)) continue;
            this.loadModule(cluster);
        }
    }

    private void checkCurrentCluster(Clusters clusters) {
        logger.fine("In instance. Looking for current cluster.");
        for (Cluster cluster : clusters.getCluster()) {
            String gmsEnString = cluster.getGmsEnabled();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("cluster %s found with gms-enabled='%s'", cluster.getName(), gmsEnString));
            }
            if (gmsEnString == null || !Boolean.parseBoolean(gmsEnString)) continue;
            this.loadModule(cluster);
            break;
        }
    }

    private void loadModule(Cluster cluster) {
        this.gmsAdapter = (GMSAdapter)this.habitat.getByContract(GMSAdapter.class);
    }
}

