/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="stop-instance")
@Async
@Scoped(value=PerLookup.class)
@I18n(value="stop.instance.command")
public class StopInstanceCommand
implements AdminCommand,
PostConstruct {
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers servers;
    @Inject
    private Configs configs;
    @Inject
    private ModulesRegistry registry;
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(optional=true, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;

    public void execute(AdminCommandContext context) {
        this.logger = context.getLogger();
        if (this.env.isDas()) {
            this.callInstance();
        } else if (this.env.isInstance()) {
            this.logger.info(Strings.get("stop.instance.init"));
            Collection modules = this.registry.getModules("org.glassfish.core.glassfish");
            if (modules.size() == 1) {
                Module mgmtAgentModule = (Module)modules.iterator().next();
                mgmtAgentModule.stop();
            } else {
                this.logger.warning(modules.size() + " no of primordial modules found");
            }
            if (this.force.booleanValue()) {
                System.exit(0);
            }
        } else {
            String msg = Strings.get("stop.instance.notAnInstanceOrDas", this.env.getRuntimeType().toString());
            this.logger.warning(msg);
        }
    }

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.env, this.servers, this.configs);
    }

    private void callInstance() {
        try {
            if (!StringUtils.ok((String)this.instanceName)) {
                this.logger.severe(Strings.get("stop.instance.noInstanceName"));
                return;
            }
            Server instance = this.helper.getServer(this.instanceName);
            if (instance == null) {
                this.logger.severe(Strings.get("stop.instance.noSuchInstance", this.instanceName));
                return;
            }
            String host = this.helper.getHost(instance);
            if (host == null) {
                this.logger.severe(Strings.get("stop.instance.noHost", this.instanceName));
                return;
            }
            int port = this.helper.getAdminPort(instance);
            if (port < 0) {
                this.logger.severe(Strings.get("stop.instance.noPort", this.instanceName));
                return;
            }
            RemoteAdminCommand rac = new RemoteAdminCommand("stop-instance", this.helper.getHost(instance), this.helper.getAdminPort(instance), false, "admin", null, this.logger);
            rac.executeCommand(new ParameterMap());
        }
        catch (CommandException ex) {
            this.logger.severe(Strings.get("stop.instance.racError", this.instanceName));
        }
    }
}

