/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class GmsAdapterService
implements Startup,
PostConstruct,
ConfigListener {
    static final Logger logger = LogDomains.getLogger(GmsAdapterService.class, (String)"javax.enterprise.system.core");
    @Inject
    Clusters clusters;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    GMSAdapter gmsAdapter;
    private List<String> gmsEnabledClusters = new LinkedList<String>();

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        if (this.clusters != null) {
            if (this.server.isDas()) {
                this.checkAllClusters(this.clusters);
            } else {
                this.checkCurrentCluster(this.clusters);
            }
        }
    }

    public String toString() {
        return "GMS Loader";
    }

    public GMSAdapter getGMSAdapter() {
        return this.gmsAdapter;
    }

    public boolean isGmsEnabled() {
        return this.gmsAdapter != null;
    }

    public GMSAdapter getGMSAdapterByName(String clusterName) {
        return this.gmsAdapter;
    }

    private void checkAllClusters(Clusters clusters) {
        logger.fine("In DAS. Checking all clusters.");
        for (Cluster cluster : clusters.getCluster()) {
            String gmsEnString = cluster.getGmsEnabled();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("cluster %s found with gms-enabled='%s'", cluster.getName(), gmsEnString));
            }
            if (gmsEnString == null || !Boolean.parseBoolean(gmsEnString)) continue;
            this.gmsEnabledClusters.add(cluster.getName());
            this.loadModule(cluster);
        }
    }

    private void checkCurrentCluster(Clusters clusters) {
        logger.fine("In instance. Looking for current cluster.");
        for (Cluster cluster : clusters.getCluster()) {
            String gmsEnString = cluster.getGmsEnabled();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("cluster %s found with gms-enabled='%s'", cluster.getName(), gmsEnString));
            }
            if (gmsEnString == null || !Boolean.parseBoolean(gmsEnString)) continue;
            this.loadModule(cluster);
            break;
        }
    }

    private void loadModule(Cluster cluster) {
        this.gmsAdapter = (GMSAdapter)this.habitat.getByContract(GMSAdapter.class);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        if (this.env.isDas()) {
            return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                    Cluster cluster;
                    if (changedType == Cluster.class && type == Changed.TYPE.ADD) {
                        cluster = (Cluster)changedInstance;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("ClusterChangeEvent add clustername=" + cluster.getName());
                        }
                        if (Boolean.valueOf(cluster.getGmsEnabled()).booleanValue() && !GmsAdapterService.this.gmsEnabledClusters.contains(cluster.getName())) {
                            GmsAdapterService.this.gmsEnabledClusters.add(cluster.getName());
                            GmsAdapterService.this.loadModule(cluster);
                            GmsAdapterService.this.gmsAdapter.getModule().reportJoinedAndReadyState(cluster.getName());
                        }
                    }
                    if (changedType == Cluster.class && type == Changed.TYPE.REMOVE && Boolean.valueOf((cluster = (Cluster)changedInstance).getGmsEnabled()).booleanValue() && GmsAdapterService.this.gmsEnabledClusters.contains(cluster.getName())) {
                        GmsAdapterService.this.gmsEnabledClusters.remove(cluster.getName());
                        if (cluster.getName().compareTo(GmsAdapterService.this.gmsAdapter.getModule().getGroupName()) == 0) {
                            GmsAdapterService.this.gmsAdapter.getModule().shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                            GmsAdapterService.this.gmsAdapter = null;
                        }
                    }
                    return null;
                }
            }, (Logger)logger);
        }
        return null;
    }
}

