/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.HostVerifier;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="SSHLauncher")
public class SSHLauncher {
    private static KnownHosts knownHostsDatabase = new KnownHosts();
    private String host;
    private int port;
    private String userName;
    private String keyFile;
    private Connection connection;
    private String authType;
    private File knownHosts;
    private Logger logger;

    public void init(Node node, Logger logger) {
        int port;
        this.logger = logger;
        SshConnector connector = node.getSshConnector();
        String host = connector.getSshHost();
        this.host = SSHUtil.checkString(host) != null ? host : node.getNodeHost();
        String sshHost = connector.getSshHost();
        if (sshHost != null) {
            this.host = sshHost;
        }
        SshAuth sshAuth = connector.getSshAuth();
        String userName = null;
        if (sshAuth != null) {
            userName = sshAuth.getUserName();
            this.keyFile = sshAuth.getKeyfile();
        }
        try {
            port = Integer.parseInt(connector.getSshPort());
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        this.init(userName, port);
    }

    private void init(String userName, int port) {
        this.port = port == 0 ? 22 : port;
        String string = this.userName = SSHUtil.checkString(userName) == null ? System.getProperty("user.name") : userName;
        if (this.knownHosts == null) {
            File home = new File(System.getProperty("user.home"));
            this.knownHosts = new File(home, ".ssh/known_hosts");
        }
        if (this.knownHosts.exists()) {
            try {
                knownHostsDatabase.addHostkeys(this.knownHosts);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void openConnection() throws IOException {
        File key;
        boolean isAuthenticated = false;
        this.connection = new Connection(this.host, this.port);
        this.connection.connect(new HostVerifier(knownHostsDatabase));
        String userName = this.userName;
        if (SSHUtil.checkString(this.keyFile) == null) {
            File home = new File(System.getProperty("user.home"));
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                File key2 = new File(home, ".ssh/" + keyName);
                if (key2.exists()) {
                    isAuthenticated = this.connection.authenticateWithPublicKey(userName, key2, null);
                }
                if (!isAuthenticated) continue;
                this.logger.fine("Authentication successful");
                break;
            }
        }
        if (!isAuthenticated && SSHUtil.checkString(this.keyFile) != null && (key = new File(this.keyFile)).exists()) {
            isAuthenticated = this.connection.authenticateWithPublicKey(userName, key, null);
        }
        if (!isAuthenticated && !this.connection.isAuthenticationComplete()) {
            this.connection.close();
            this.connection = null;
            this.logger.fine("Could not authenticate");
            throw new IOException("Could not authenticate");
        }
        SSHUtil.register(this.connection);
    }

    public int runCommand(String command, OutputStream os) throws IOException, InterruptedException {
        this.logger.fine("Running command " + command + " on host: " + this.host);
        this.openConnection();
        int status = this.connection.exec(command, os);
        SSHUtil.unregister(this.connection);
        this.connection = null;
        return status;
    }

    public boolean validate(String host, int port, String userName, String keyFile, String nodeHome, Logger logger) throws IOException {
        this.host = host;
        this.keyFile = keyFile;
        this.logger = logger;
        boolean isValid = false;
        this.init(userName, port);
        this.openConnection();
        logger.fine("Connection settings valid");
        SFTPClient sftpClient = new SFTPClient(this.connection);
        isValid = sftpClient.exists(nodeHome);
        logger.fine("Node home validated");
        SSHUtil.unregister(this.connection);
        this.connection = null;
        return isValid;
    }
}

