/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;

class ClusterCommandHelper {
    private static final String NL = System.getProperty("line.separator");
    private Domain domain;
    private CommandRunner runner;

    ClusterCommandHelper(Domain domain, CommandRunner runner) {
        this.domain = domain;
        this.runner = runner;
    }

    ActionReport runCommand(String command, ParameterMap map, String clusterName, AdminCommandContext context, boolean verbose) throws CommandException {
        Logger logger = context.getLogger();
        ActionReport report = context.getActionReport();
        Cluster cluster = this.domain.getClusterNamed(clusterName);
        if (cluster == null) {
            String msg = Strings.get("cluster.command.unknownCluster", clusterName);
            throw new CommandException(msg);
        }
        List targetServers = this.domain.getServersInTarget(clusterName);
        StringBuilder failedServerNames = new StringBuilder();
        StringBuilder succeededServerNames = new StringBuilder();
        boolean failureOccurred = false;
        StringBuilder output = new StringBuilder();
        CommandRunner.CommandInvocation invocation = this.runner.getCommandInvocation(command, report);
        if (map == null) {
            map = new ParameterMap();
        }
        for (Server server : targetServers) {
            map.set((Object)"DEFAULT", (Object)server.getName());
            invocation.parameters(map);
            String msg = command + " " + server.getName();
            logger.info(msg);
            if (verbose) {
                output.append(msg).append(NL);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            invocation.execute();
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                failureOccurred = true;
                failedServerNames.append(server.getName()).append(" ");
                msg = report.getMessage();
                logger.severe(msg);
                output.append(msg).append(NL);
                continue;
            }
            succeededServerNames.append(server.getName()).append(" ");
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (succeededServerNames.length() > 0 && (verbose || failureOccurred)) {
            output.append(NL + Strings.get("cluster.command.instancesSucceeded", command, succeededServerNames));
        }
        if (failureOccurred) {
            output.append(NL + Strings.get("cluster.command.instancesFailed", command, failedServerNames));
            if (succeededServerNames.length() > 0) {
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        report.setMessage(output.toString());
        return report;
    }
}

