/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-config")
@Scoped(value=PerLookup.class)
@I18n(value="delete.config.command")
public final class DeleteConfigCommand
implements AdminCommand {
    @Param(primary=true)
    String destConfig;
    @Inject
    Configs configs;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConfigCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.destConfig.equals("default-config")) {
            report.setMessage(localStrings.getLocalString("Config.defaultConfig", "The default configuration template named default-config cannot be deleted."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final Config config = this.domain.getConfigNamed(this.destConfig);
        if (config == null) {
            report.setMessage(localStrings.getLocalString("Config.noSuchConfig", "Config {0} does not exist.", new Object[]{this.destConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List refContainers = this.domain.getReferenceContainersOf(config);
        if (refContainers.size() >= 1) {
            StringBuffer namesOfContainers = new StringBuffer();
            for (ReferenceContainer rc : refContainers) {
                namesOfContainers.append(rc.getReference()).append(',');
            }
            report.setMessage(localStrings.getLocalString("Config.inUseConfig", "Config {0} is in use and must be referenced by no server instances or clusters", new Object[]{this.destConfig, namesOfContainers}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Configs>(){

                public Object run(Configs c) throws PropertyVetoException, TransactionFailure {
                    List configList = c.getConfig();
                    configList.remove(config);
                    return null;
                }
            }, (ConfigBeanProxy)this.configs);
        }
        catch (TransactionFailure ex) {
            report.setMessage(localStrings.getLocalString("Config.deleteConfigFailed", "Unable to remove config {0} ", new Object[]{config}) + " " + ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
        }
    }
}

