/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="delete-instance")
@I18n(value="delete.instance")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class DeleteInstanceCommand
implements AdminCommand,
PostConstruct {
    private static final String DEFAULT_NODE = "localhost";
    private static final String LOCAL_HOST = "localhost";
    private static final String NL = System.getProperty("line.separator");
    private ParameterMap map;
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Param(name="node", optional=true, defaultValue="localhost")
    String node;
    @Param(name="nodeagent", optional=true)
    String nodeAgent;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger;
    private AdminCommandContext ctx;
    private RemoteInstanceCommandHelper helper;
    private RemoteConnectHelper rch;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        int dasPort = this.helper.getAdminPort("server");
        String dasHost = System.getProperty("com.sun.aas.hostName");
        this.rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, dasHost, dasPort);
        if (this.nodes.getNode(this.node) == null) {
            String msg = Strings.get("noSuchNode", this.node);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.rch.isLocalhost(this.nodes.getNode(this.node))) {
            LocalAdminCommand lac = new LocalAdminCommand("delete-local-instance", new String[]{this.instance});
            String msg = Strings.get("deletingInstance", this.instance, "localhost");
            this.logger.info(msg);
            try {
                int status = lac.execute();
            }
            catch (ProcessManagerException ex) {
                msg = Strings.get("delete.instance.remote.failed", this.instance);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
                return;
            }
        } else if (this.rch.isRemoteConnectRequired(this.node)) {
            String msg = Strings.get("deletingInstance", this.instance, this.node);
            this.logger.info(msg);
            int status = this.deleteInstanceRemote();
            if (status != 0) {
                return;
            }
        } else {
            String msg = Strings.get("delete.instance.failed", this.instance);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
    }

    private int deleteInstanceRemote() {
        ActionReport report = this.ctx.getActionReport();
        StringBuilder output = new StringBuilder();
        ParameterMap map = new ParameterMap();
        map.add((Object)"--filesystemonly", (Object)"true");
        map.add((Object)"DEFAULT", (Object)this.instance);
        int status = this.rch.runCommand(this.node, "delete-local-instance", map, output);
        if (output.length() > 0) {
            this.logger.info(output.toString());
        }
        if (status != 0) {
            String msg = Strings.get("delete.instance.remote.failed", this.instance);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(output.toString() + NL + msg);
            return 1;
        }
        return 0;
    }
}

