/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="list-clusters")
@Scoped(value=PerLookup.class)
@I18n(value="list.clusters.command")
public final class ListClustersCommand
implements AdminCommand,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    Domain domain;
    private RemoteInstanceCommandHelper helper;
    private List<InstanceInfo> infos = new LinkedList<InstanceInfo>();
    private static final String NONE = "Nothing to list.";
    private static final String EOL = "\n";

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Logger logger = context.getLogger();
        ActionReport.MessagePart top = report.getTopMessagePart();
        Clusters clusters = this.domain.getClusters();
        List clusterList = clusters.getCluster();
        StringBuilder sb = new StringBuilder();
        if (clusterList.size() < 1) {
            sb.append(NONE);
        }
        boolean atleastOneInstanceRunning = false;
        boolean allInstancesRunning = true;
        int timeoutInMsec = 2000;
        boolean firstCluster = true;
        for (Cluster cluster : clusterList) {
            String value;
            String display;
            String clusterName = cluster.getName();
            System.out.println("DEBUGGING hudson** cluster" + clusterName);
            List servers = cluster.getInstances();
            System.out.println("DEBUGGING hudson** servers size" + servers.size());
            for (Server server : servers) {
                String name = server.getName();
                System.out.println("DEBUGGING hudson** server" + name);
                if (name == null) continue;
                InstanceInfo ii = new InstanceInfo(name, this.helper.getAdminPort(server), this.helper.getHost(server), clusterName, logger, timeoutInMsec);
                this.infos.add(ii);
                System.out.println("DEBUGGING hudson** instance is running" + ii.isRunning());
                allInstancesRunning &= ii.isRunning();
                if (!ii.isRunning()) continue;
                atleastOneInstanceRunning = true;
            }
            if (servers.isEmpty() || !atleastOneInstanceRunning) {
                display = " not running";
                value = "NOT_RUNNING";
            } else if (allInstancesRunning) {
                display = " running";
                value = "RUNNING";
            } else {
                display = " partially running";
                value = "PARTIALLY_RUNNING";
            }
            if (firstCluster) {
                firstCluster = false;
            } else {
                sb.append(EOL);
            }
            sb.append(clusterName).append(display);
            top.addProperty(clusterName, value);
        }
        report.setMessage(sb.toString());
    }
}

