/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.StopLocalInstanceCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-local-instance")
@Scoped(value=PerLookup.class)
public class RestartLocalInstanceCommand
extends StopLocalInstanceCommand {
    @Inject
    private Habitat habitat;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartLocalInstanceCommand.class);

    protected final int doRemoteCommand() throws CommandException {
        long uptimeOldServer = this.getUptime();
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long timestamp = pwFile != null ? pwFile.lastModified() : -1L;
        RemoteCommand cmd = new RemoteCommand("restart-instance", this.programOpts, this.env);
        cmd.executeAndReturnOutput(new String[]{"restart-instance"});
        this.waitForRestart(pwFile, timestamp, uptimeOldServer);
        return 0;
    }

    protected int instanceNotRunning() throws CommandException {
        logger.printWarning(strings.get("restart.instanceNotRunning"));
        CLICommand cmd = (CLICommand)this.habitat.getComponent(CLICommand.class, "start-local-instance");
        return cmd.execute(this.argv);
    }
}

