/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.cluster.CreateLocalInstanceFilesystemCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-local-instance")
@Scoped(value=PerLookup.class)
public final class CreateLocalInstanceCommand
extends CreateLocalInstanceFilesystemCommand {
    @Param(name="config", optional=true)
    private String configName;
    @Param(name="cluster", optional=true)
    private String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    private static final String RENDEZVOUS_PROPERTY_NAME = "rendezvousOccurred";
    private String INSTANCE_DOTTED_NAME;
    private String RENDEZVOUS_DOTTED_NAME;
    private boolean _rendezvousOccurred;
    private String _node;

    protected void validate() throws CommandException {
        if (this.configName != null && this.clusterName != null) {
            throw new CommandException(Strings.get("ConfigClusterConflict"));
        }
        super.validate();
        this.INSTANCE_DOTTED_NAME = "servers.server." + this.instanceName;
        this.RENDEZVOUS_DOTTED_NAME = this.INSTANCE_DOTTED_NAME + ".property." + RENDEZVOUS_PROPERTY_NAME;
        if (!this.rendezvousWithDAS()) {
            this.instanceDir.delete();
            throw new CommandException(Strings.get("Instance.rendezvousFailed", this.DASHost, "" + this.DASPort));
        }
        this._rendezvousOccurred = this.rendezvousOccurred();
        if (this._rendezvousOccurred) {
            throw new CommandException(Strings.get("Instance.rendezvousAlready", this.instanceName, this.DASHost, "" + this.DASPort));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        int exitCode = -1;
        if (this.node == null) {
            this._node = this.getInstanceHostName(false);
            String nodeHost = this.getInstanceHostName(true);
            this.createNodeImplicit(this._node, this.getInstallRootPath(), nodeHost);
        } else {
            this._node = this.node;
        }
        if (this.isRegisteredToDAS()) {
            if (!this._rendezvousOccurred) {
                this.setRendezvousOccurred("true");
                this._rendezvousOccurred = true;
            }
        } else {
            try {
                this.registerToDAS();
                this._rendezvousOccurred = true;
            }
            catch (CommandException ce) {
                this.instanceDir.delete();
                throw ce;
            }
        }
        try {
            exitCode = super.executeCommand();
        }
        catch (CommandException ce) {
            String msg = "Something went wrong in creating the local filesystem for instance " + this.instanceName;
            if (ce.getLocalizedMessage() != null) {
                msg = msg + ": " + ce.getLocalizedMessage();
            }
            logger.printError(msg);
            this.setRendezvousOccurred("false");
            this._rendezvousOccurred = false;
            throw new CommandException(msg, (Throwable)ce);
        }
        return exitCode;
    }

    private boolean rendezvousWithDAS() {
        try {
            logger.printMessage(Strings.get("Instance.rendezvousAttempt", this.DASHost, "" + this.DASPort));
            boolean success = false;
            RemoteCommand rc = new RemoteCommand("uptime", this.programOpts, this.env);
            int exitCode = rc.execute(new String[]{"uptime"});
            if (exitCode == 0) {
                logger.printMessage(Strings.get("Instance.rendezvousSuccess", this.DASHost, "" + this.DASPort));
                success = true;
            }
            return success;
        }
        catch (CommandException ex) {
            return false;
        }
    }

    private int registerToDAS() throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_register-instance");
        if (this.clusterName != null) {
            argsList.add("--cluster");
            argsList.add(this.clusterName);
        }
        if (this.configName != null) {
            argsList.add("--config");
            argsList.add(this.configName);
        }
        if (this.nodeAgent != null) {
            argsList.add("--nodeagent");
            argsList.add(this.nodeAgent);
        }
        if (this._node != null) {
            argsList.add("--node");
            argsList.add(this._node);
        }
        if (this.systemProperties != null) {
            argsList.add("--systemproperties");
            argsList.add(this.systemProperties);
        }
        argsList.add("--properties");
        argsList.add("rendezvousOccurred=true");
        argsList.add(this.instanceName);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("_register-instance", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private boolean isRegisteredToDAS() {
        boolean isRegistered = false;
        try {
            RemoteCommand rc = new RemoteCommand("get", this.programOpts, this.env);
            int exitCode = rc.execute(new String[]{"get", this.INSTANCE_DOTTED_NAME});
            if (exitCode == 0) {
                isRegistered = true;
            }
        }
        catch (CommandException ex) {
            logger.printDebugMessage("asadmin get " + this.INSTANCE_DOTTED_NAME + " failed.");
            logger.printDebugMessage(this.instanceName + " may not be registered yet to DAS.");
        }
        return isRegistered;
    }

    private boolean rendezvousOccurred() {
        boolean rendezvousOccurred;
        block4: {
            rendezvousOccurred = false;
            RemoteCommand rc = null;
            try {
                rc = new RemoteCommand("get", this.programOpts, this.env);
                Map map = rc.executeAndReturnAttributes(new String[]{"get", this.RENDEZVOUS_DOTTED_NAME});
                String output = (String)map.get("children");
                String val = output.substring(output.indexOf("=") + 1);
                rendezvousOccurred = Boolean.parseBoolean(val);
                if (CLILogger.isDebug()) {
                    logger.printDebugMessage("rendezvousOccurred = " + val + " for instance " + this.instanceName);
                }
            }
            catch (CommandException ce) {
                logger.printDebugMessage("Remote command failed:");
                if (rc != null) {
                    logger.printDebugMessage(rc.toString());
                }
                logger.printDebugMessage("rendezvousOccurred property may not be set yet on instance " + this.instanceName);
                if (ce.getLocalizedMessage() == null) break block4;
                logger.printDebugMessage(ce.getLocalizedMessage());
            }
        }
        return rendezvousOccurred;
    }

    private int setRendezvousOccurred(String rendezVal) throws CommandException {
        String dottedName = this.RENDEZVOUS_DOTTED_NAME + "=" + rendezVal;
        RemoteCommand rc = new RemoteCommand("set", this.programOpts, this.env);
        if (CLILogger.isDebug()) {
            logger.printDebugMessage("Setting rendezvousOccurred to " + rendezVal + " for instance " + this.instanceName);
            logger.printDebugMessage(rc.toString());
        }
        return rc.execute(new String[]{"set", dottedName});
    }

    private int createNodeImplicit(String name, String installdir, String nodeHost) throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_create-node-implicit");
        if (name != null) {
            argsList.add("--name");
            argsList.add(name);
        }
        if (this.nodeDir != null) {
            argsList.add("--nodedir");
            argsList.add(this.nodeDir);
        } else {
            argsList.add("--nodedir");
            argsList.add(installdir + File.separator + "nodeagents");
        }
        if (installdir != null) {
            argsList.add("--installdir");
            argsList.add(installdir);
        }
        argsList.add(nodeHost);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("_create-node-implicit", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private String getInstanceHostName(boolean isCanonical) throws CommandException {
        String instanceHostName = null;
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new CommandException(Strings.get("Agent.cantGetHostName", ex));
        }
        if (localHost != null) {
            instanceHostName = isCanonical ? localHost.getCanonicalHostName() : localHost.getHostName();
        }
        return instanceHostName;
    }
}

