/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;

public class NodeUtils {
    static final String NODE_DEFAULT_SSH_PORT = "22";
    static final String NODE_DEFAULT_SSH_USER = "${user.name}";
    static final String NODE_DEFAULT_INSTALLDIR = "${com.sun.aas.installRoot}";
    private static final String NL = System.getProperty("line.separator");
    private TokenResolver resolver = null;
    private Logger logger = null;

    NodeUtils(Logger logger) {
        this.logger = logger;
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    void validate(ParameterMap map, SSHLauncher sshL) throws CommandValidationException {
        String sshkeyfile = (String)map.getOne((Object)"sshkeyfile");
        if (StringUtils.ok((String)sshkeyfile)) {
            File kfile = new File(this.resolver.resolve(sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
        if (sshL != null) {
            this.validateSSHConnection(map, sshL);
        }
    }

    private void validateSSHConnection(ParameterMap map, SSHLauncher sshL) throws CommandValidationException {
        String nodehost = (String)map.getOne((Object)"nodehost");
        String installdir = (String)map.getOne((Object)"installdir");
        String nodedir = (String)map.getOne((Object)"nodedir");
        String sshport = (String)map.getOne((Object)"sshport");
        String sshuser = (String)map.getOne((Object)"sshuser");
        String sshkeyfile = (String)map.getOne((Object)"sshkeyfile");
        if (!NetUtils.isPortStringValid((String)this.resolver.resolve(sshport))) {
            throw new CommandValidationException(Strings.get("ssh.invalid.port", sshport));
        }
        int port = Integer.parseInt(this.resolver.resolve(sshport));
        try {
            sshL.validate(this.resolver.resolve(nodehost), port, this.resolver.resolve(sshuser), this.resolver.resolve(sshkeyfile), this.resolver.resolve(installdir), this.logger);
        }
        catch (IOException e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            if (e instanceof FileNotFoundException) {
                this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{m1, m2, sshL.toString()}));
                throw new CommandValidationException(StringUtils.cat((String)NL, (String[])new String[]{m1, m2}));
            }
            String msg = Strings.get("ssh.bad.connect", nodehost);
            this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{msg, m1, m2, sshL.toString()}));
            throw new CommandValidationException(StringUtils.cat((String)NL, (String[])new String[]{msg, m1, m2}));
        }
    }
}

