/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.cluster.CreateLocalInstanceFilesystemCommand;
import com.sun.enterprise.admin.cli.cluster.PortBaseHelper;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-local-instance")
@Scoped(value=PerLookup.class)
public final class CreateLocalInstanceCommand
extends CreateLocalInstanceFilesystemCommand {
    private final String CONFIG = "config";
    private final String CLUSTER = "cluster";
    @Param(name="config", optional=true)
    private String configName;
    @Param(name="cluster", optional=true)
    private String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="portbase", optional=true)
    private String portBase;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts = true;
    private static final String RENDEZVOUS_PROPERTY_NAME = "rendezvousOccurred";
    private String INSTANCE_DOTTED_NAME;
    private String RENDEZVOUS_DOTTED_NAME;
    private boolean _rendezvousOccurred;
    private String _node;
    private PortBaseHelper pbh;

    protected void validate() throws CommandException {
        if (this.configName != null && this.clusterName != null) {
            throw new CommandException(Strings.get("ConfigClusterConflict"));
        }
        if (this.node != null) {
            this.validateNode(this.node, this.getInstallRootPath(), this.getInstanceHostName(true));
        }
        this.pbh = new PortBaseHelper(this.portBase, this.checkPorts);
        this.pbh.verifyPortBase();
        super.validate();
        this.INSTANCE_DOTTED_NAME = "servers.server." + this.instanceName;
        this.RENDEZVOUS_DOTTED_NAME = this.INSTANCE_DOTTED_NAME + ".property." + RENDEZVOUS_PROPERTY_NAME;
        if (!this.rendezvousWithDAS()) {
            this.instanceDir.delete();
            throw new CommandException(Strings.get("Instance.rendezvousFailed", this.DASHost, "" + this.DASPort));
        }
        this._rendezvousOccurred = this.rendezvousOccurred();
        if (this._rendezvousOccurred) {
            throw new CommandException(Strings.get("Instance.rendezvousAlready", this.instanceName, this.DASHost, "" + this.DASPort));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        int exitCode = -1;
        if (this.node == null) {
            this._node = this.nodeDirChild.getName();
            String nodeHost = this.getInstanceHostName(true);
            this.createNodeImplicit(this._node, this.getInstallRootPath(), nodeHost);
        } else {
            this._node = this.node;
        }
        if (this.isRegisteredToDAS()) {
            if (!this._rendezvousOccurred) {
                this.setRendezvousOccurred("true");
                this._rendezvousOccurred = true;
            }
        } else {
            try {
                this.registerToDAS();
                this._rendezvousOccurred = true;
            }
            catch (CommandException ce) {
                this.instanceDir.delete();
                throw ce;
            }
        }
        try {
            exitCode = super.executeCommand();
        }
        catch (CommandException ce) {
            String msg = "Something went wrong in creating the local filesystem for instance " + this.instanceName;
            if (ce.getLocalizedMessage() != null) {
                msg = msg + ": " + ce.getLocalizedMessage();
            }
            logger.printError(msg);
            this.setRendezvousOccurred("false");
            this._rendezvousOccurred = false;
            throw new CommandException(msg, (Throwable)ce);
        }
        return exitCode;
    }

    private boolean rendezvousWithDAS() {
        try {
            logger.printMessage(Strings.get("Instance.rendezvousAttempt", this.DASHost, "" + this.DASPort));
            boolean success = false;
            RemoteCommand rc = new RemoteCommand("uptime", this.programOpts, this.env);
            int exitCode = rc.execute(new String[]{"uptime"});
            if (exitCode == 0) {
                logger.printMessage(Strings.get("Instance.rendezvousSuccess", this.DASHost, "" + this.DASPort));
                success = true;
            }
            return success;
        }
        catch (CommandException ex) {
            return false;
        }
    }

    private int registerToDAS() throws CommandException {
        if (this.portBase != null) {
            this.setPorts();
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_register-instance");
        if (this.clusterName != null) {
            argsList.add("--cluster");
            argsList.add(this.clusterName);
        }
        if (this.configName != null) {
            argsList.add("--config");
            argsList.add(this.configName);
        }
        if (this._node != null) {
            argsList.add("--node");
            argsList.add(this._node);
        }
        if (this.systemProperties != null) {
            argsList.add("--systemproperties");
            argsList.add(this.systemProperties);
        }
        argsList.add("--properties");
        argsList.add("rendezvousOccurred=true");
        argsList.add(this.instanceName);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("_register-instance", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private boolean isRegisteredToDAS() {
        boolean isRegistered = false;
        try {
            RemoteCommand rc = new RemoteCommand("get", this.programOpts, this.env);
            int exitCode = rc.execute(new String[]{"get", this.INSTANCE_DOTTED_NAME});
            if (exitCode == 0) {
                isRegistered = true;
            }
        }
        catch (CommandException ex) {
            logger.printDebugMessage("asadmin get " + this.INSTANCE_DOTTED_NAME + " failed.");
            logger.printDebugMessage(this.instanceName + " may not be registered yet to DAS.");
        }
        return isRegistered;
    }

    private boolean rendezvousOccurred() {
        boolean rendezvousOccurred;
        block4: {
            rendezvousOccurred = false;
            RemoteCommand rc = null;
            try {
                rc = new RemoteCommand("get", this.programOpts, this.env);
                Map map = rc.executeAndReturnAttributes(new String[]{"get", this.RENDEZVOUS_DOTTED_NAME});
                String output = (String)map.get("children");
                String val = output.substring(output.indexOf("=") + 1);
                rendezvousOccurred = Boolean.parseBoolean(val);
                if (CLILogger.isDebug()) {
                    logger.printDebugMessage("rendezvousOccurred = " + val + " for instance " + this.instanceName);
                }
            }
            catch (CommandException ce) {
                logger.printDebugMessage("Remote command failed:");
                if (rc != null) {
                    logger.printDebugMessage(rc.toString());
                }
                logger.printDebugMessage("rendezvousOccurred property may not be set yet on instance " + this.instanceName);
                if (ce.getLocalizedMessage() == null) break block4;
                logger.printDebugMessage(ce.getLocalizedMessage());
            }
        }
        return rendezvousOccurred;
    }

    private int setRendezvousOccurred(String rendezVal) throws CommandException {
        String dottedName = this.RENDEZVOUS_DOTTED_NAME + "=" + rendezVal;
        RemoteCommand rc = new RemoteCommand("set", this.programOpts, this.env);
        if (CLILogger.isDebug()) {
            logger.printDebugMessage("Setting rendezvousOccurred to " + rendezVal + " for instance " + this.instanceName);
            logger.printDebugMessage(rc.toString());
        }
        return rc.execute(new String[]{"set", dottedName});
    }

    private int createNodeImplicit(String name, String installdir, String nodeHost) throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_create-node-implicit");
        if (name != null) {
            argsList.add("--name");
            argsList.add(name);
        }
        if (this.nodeDir != null) {
            argsList.add("--nodedir");
            argsList.add(this.nodeDir);
        }
        if (installdir != null) {
            argsList.add("--installdir");
            argsList.add(installdir);
        }
        argsList.add(nodeHost);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("_create-node-implicit", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private int validateNode(String name, String installdir, String nodeHost) throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_validate-node");
        if (this.nodeDir != null) {
            argsList.add("--nodedir");
            argsList.add(this.nodeDir);
        }
        if (nodeHost != null) {
            argsList.add("--nodehost");
            argsList.add(nodeHost);
        }
        if (installdir != null) {
            argsList.add("--installdir");
            argsList.add(installdir);
        }
        argsList.add(name);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCommand rc = new RemoteCommand("_validate-node", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private void setPorts() {
        if (this.portBase != null) {
            StringBuffer sb = this.systemProperties == null ? new StringBuffer() : new StringBuffer(this.systemProperties);
            if (sb.indexOf("ASADMIN_LISTENER_PORT") == -1) {
                sb.append(":ASADMIN_LISTENER_PORT=" + this.pbh.getAdminPort());
            }
            if (sb.indexOf("HTTP_LISTENER_PORT") == -1) {
                sb.append(":HTTP_LISTENER_PORT=" + this.pbh.getInstancePort());
            }
            if (sb.indexOf("HTTP_SSL_LISTENER_PORT") == -1) {
                sb.append(":HTTP_SSL_LISTENER_PORT=" + this.pbh.getHttpsPort());
            }
            if (sb.indexOf("IIOP_LISTENER_PORT") == -1) {
                sb.append(":IIOP_LISTENER_PORT=" + this.pbh.getIiopPort());
            }
            if (sb.indexOf("IIOP_SSL_MUTUALAUTH_PORT") == -1) {
                sb.append(":IIOP_SSL_MUTUALAUTH_PORT=" + this.pbh.getIiopmPort());
            }
            if (sb.indexOf("IIOP_SSL_LISTENER_PORT") == -1) {
                sb.append(":IIOP_SSL_LISTENER_PORT=" + this.pbh.getIiopsPort());
            }
            if (sb.indexOf("JMS_PROVIDER_PORT") == -1) {
                sb.append(":JMS_PROVIDER_PORT=" + this.pbh.getJmsPort());
            }
            if (sb.indexOf("JMX_SYSTEM_CONNECTOR_PORT") == -1) {
                sb.append(":JMX_SYSTEM_CONNECTOR_PORT=" + this.pbh.getJmxPort());
            }
            this.systemProperties = sb.charAt(0) == ':' ? sb.substring(1) : sb.toString();
        }
    }

    private String getInstanceHostName(boolean isCanonical) throws CommandException {
        String instanceHostName = null;
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new CommandException(Strings.get("cantGetHostName", ex));
        }
        if (localHost != null) {
            instanceHostName = isCanonical ? localHost.getCanonicalHostName() : localHost.getHostName();
        }
        return instanceHostName;
    }

    public String getUsage() {
        String str;
        String newStr = str = super.getUsage();
        StringBuffer sb = new StringBuffer(str);
        String config = "--config <config>";
        String cluster = "--cluster <cluster>";
        String oldConfigCluster = "[" + config + "] [" + cluster + "]";
        String newConfigCluster = "[" + config + " | " + cluster + "]";
        int start = sb.indexOf(oldConfigCluster);
        if (start != -1) {
            int end = start + oldConfigCluster.length();
            StringBuffer newsb = sb.replace(start, end, newConfigCluster);
            newStr = newsb.toString();
        }
        return newStr;
    }
}

