/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_create-instance-filesystem")
@Scoped(value=PerLookup.class)
public class CreateLocalInstanceFilesystemCommand
extends LocalInstanceCommand {
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    private boolean saveMasterPassword = false;
    @Param(name="instance_name", primary=true)
    private String instanceName0;
    String DASHost;
    int DASPort = -1;
    String DASProtocol;
    boolean dasIsSecure;
    private File agentConfigDir;
    private File applicationsDir;
    private File configDir;
    private File generatedDir;
    private File libDir;
    private File docrootDir;
    private File dasPropsFile;
    private Properties dasProperties;
    private File loggingPropsFile;

    protected void validate() throws CommandException {
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.instanceName0)) {
            throw new CommandException(Strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        super.validate();
        String agentPath = "agent" + File.separator + "config";
        this.agentConfigDir = new File(this.nodeDirChild, agentPath);
        this.dasPropsFile = new File(this.agentConfigDir, "das.properties");
        this.applicationsDir = new File(this.instanceDir, "applications");
        this.configDir = new File(this.instanceDir, "config");
        this.generatedDir = new File(this.instanceDir, "generated");
        this.libDir = new File(this.instanceDir, "lib");
        this.docrootDir = new File(this.instanceDir, "docroot");
        this.loggingPropsFile = new File(this.configDir, "logging.properties");
        if (this.dasPropsFile.isFile()) {
            this.setDasDefaults(this.dasPropsFile);
            logger.printMessage(Strings.get("Instance.existingDasPropertiesWarning", this.programOpts.getHost(), "" + this.programOpts.getPort(), this.node));
        }
        this.DASHost = this.programOpts.getHost();
        this.DASPort = this.programOpts.getPort();
        this.dasIsSecure = this.programOpts.isSecure();
        this.DASProtocol = "http";
    }

    protected int executeCommand() throws CommandException {
        return this.createDirectories();
    }

    private int createDirectories() throws CommandException {
        boolean createDirsComplete = false;
        File badfile = null;
        while (badfile == null && !createDirsComplete) {
            if (!this.agentConfigDir.isDirectory() && !this.agentConfigDir.mkdirs()) {
                badfile = this.agentConfigDir;
            }
            if (!this.applicationsDir.isDirectory() && !this.applicationsDir.mkdir()) {
                badfile = this.applicationsDir;
            }
            if (!this.configDir.isDirectory() && !this.configDir.mkdir()) {
                badfile = this.configDir;
            }
            if (!this.generatedDir.isDirectory() && !this.generatedDir.mkdir()) {
                badfile = this.generatedDir;
            }
            if (!this.libDir.isDirectory() && !this.libDir.mkdir()) {
                badfile = this.libDir;
            }
            if (!this.docrootDir.isDirectory() && !this.docrootDir.mkdir()) {
                badfile = this.docrootDir;
            }
            createDirsComplete = true;
        }
        if (badfile != null) {
            throw new CommandException(Strings.get("Instance.cannotMkDir", badfile));
        }
        this.writeProperties();
        return 0;
    }

    private void writeProperties() throws CommandException {
        String filename = "";
        try {
            filename = this.dasPropsFile.getName();
            if (!this.dasPropsFile.isFile()) {
                this.writeDasProperties();
            }
            filename = this.loggingPropsFile.getName();
            this.writeLoggingProperties();
        }
        catch (IOException ex) {
            throw new CommandException(Strings.get("Instance.cantWriteProperties", filename), (Throwable)ex);
        }
    }

    private void writeDasProperties() throws IOException {
        this.dasPropsFile.createNewFile();
        this.dasProperties = new Properties();
        this.dasProperties.setProperty("agent.das.host", this.DASHost);
        this.dasProperties.setProperty("agent.das.port", String.valueOf(this.DASPort));
        this.dasProperties.setProperty("agent.das.isSecure", String.valueOf(this.dasIsSecure));
        this.dasProperties.setProperty("agent.das.protocol", this.DASProtocol);
        FileOutputStream fos = new FileOutputStream(this.dasPropsFile);
        this.dasProperties.store(fos, Strings.get("Instance.dasPropertyComment"));
        fos.close();
    }

    private void writeLoggingProperties() throws IOException {
        String rootFolder = this.getSystemProperty("com.sun.aas.installRoot");
        String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
        File src = new File(templateDir, "logging.properties");
        FileUtils.copy((File)src, (File)this.loggingPropsFile);
    }
}

