/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.LocalServerCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.InstanceDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class LocalInstanceCommand
extends LocalServerCommand {
    @Param(name="nodedir", optional=true, alias="agentdir")
    protected String nodeDir;
    @Param(name="node", optional=true, alias="nodeagent")
    protected String node;
    protected String instanceName;
    protected File nodeDirRoot;
    protected File nodeDirChild;
    protected File instanceDir;
    private InstanceDirs instanceDirs;

    protected void validate() throws CommandException, CommandValidationException {
        this.initInstance();
    }

    protected boolean mkdirs(File f) {
        return f.mkdirs();
    }

    protected void initInstance() throws CommandException {
        String nodeDirRootPath = null;
        nodeDirRootPath = LocalInstanceCommand.ok((String)this.nodeDir) ? this.nodeDir : this.getNodeDirRootDefault();
        this.nodeDirRoot = new File(nodeDirRootPath);
        this.mkdirs(this.nodeDirRoot);
        if (!this.nodeDirRoot.isDirectory()) {
            throw new CommandException(Strings.get("Instance.badNodeDir", this.nodeDirRoot));
        }
        this.nodeDirChild = this.node != null ? new File(this.nodeDirRoot, this.node) : this.getTheOneAndOnlyNode(this.nodeDirRoot);
        if (this.instanceName != null) {
            this.instanceDir = new File(this.nodeDirChild, this.instanceName);
            this.mkdirs(this.instanceDir);
        } else {
            this.instanceDir = this.getTheOneAndOnlyInstance(this.nodeDirChild);
            this.instanceName = this.instanceDir.getName();
        }
        if (!this.instanceDir.isDirectory()) {
            throw new CommandException(Strings.get("Instance.badInstanceDir", this.instanceDir));
        }
        this.nodeDirChild = SmartFile.sanitize((File)this.nodeDirChild);
        this.instanceDir = SmartFile.sanitize((File)this.instanceDir);
        try {
            this.instanceDirs = new InstanceDirs(this.instanceDir);
            this.setServerDirs(this.instanceDirs.getServerDirs());
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        logger.printDebugMessage("nodeDirChild: " + this.nodeDirChild);
        logger.printDebugMessage("instanceDir: " + this.instanceDir);
    }

    protected final InstanceDirs getInstanceDirs() {
        return this.instanceDirs;
    }

    protected final void setDasDefaults(File propfile) throws CommandException {
        Properties dasprops = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propfile);
            dasprops.load(fis);
            fis.close();
            fis = null;
            String p = dasprops.getProperty("agent.das.host");
            if (p != null) {
                this.programOpts.setHost(p);
            }
            p = dasprops.getProperty("agent.das.port");
            int port = -1;
            if (p != null) {
                port = Integer.parseInt(p);
            }
            if ((p = dasprops.getProperty("agent.das.protocol")) != null && p.equals("rmi_jrmp")) {
                this.programOpts.setPort(this.updateDasPort(dasprops, port, propfile));
            } else if (p == null || p.equals("http")) {
                this.programOpts.setPort(port);
            } else {
                throw new CommandException(Strings.get("Instance.badProtocol", propfile.toString(), p));
            }
            p = dasprops.getProperty("agent.das.isSecure");
            if (p != null) {
                this.programOpts.setSecure(Boolean.parseBoolean(p));
            }
            if ((p = dasprops.getProperty("agent.das.user")) != null) {
                this.programOpts.setUser(p);
            }
        }
        catch (IOException ioex) {
            throw new CommandException(Strings.get("Instance.cantReadDasProperties", propfile.getPath()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException cex) {}
            }
        }
    }

    protected final void whackFilesystem() throws CommandException {
        File whackee = this.getServerDirs().getServerDir();
        if (whackee == null || !whackee.isDirectory()) {
            throw new CommandException(Strings.get("DeleteInstance.noWhack", whackee));
        }
        FileUtils.whack((File)whackee);
        if (whackee.isDirectory()) {
            throw new CommandException(Strings.get("DeleteInstance.badWhack", whackee));
        }
    }

    protected String getInstallRootPath() throws CommandException {
        String installRootPath = this.getSystemProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok((String)installRootPath)) {
            installRootPath = System.getProperty("com.sun.aas.installRoot");
        }
        if (!StringUtils.ok((String)installRootPath)) {
            throw new CommandException("noInstallDirPath");
        }
        return installRootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateDasPort(Properties dasprops, int port, File propfile) {
        if (port == 8686) {
            logger.printMessage(Strings.get("Instance.oldDasProperties", propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())));
            port = this.programOpts.getPort();
        } else {
            Console cons = System.console();
            if (cons != null) {
                String line = cons.readLine("%s", Strings.get("Instance.oldDasPropertiesPrompt", propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())));
                while (line != null && line.length() > 0) {
                    block19: {
                        try {
                            port = Integer.parseInt(line);
                            if (port <= 0 || port > 65535) break block19;
                            break;
                        }
                        catch (NumberFormatException nfex) {
                            // empty catch block
                        }
                    }
                    line = cons.readLine(Strings.get("Instance.reenterPort"), Integer.toString(this.programOpts.getPort()));
                }
            } else {
                logger.printMessage(Strings.get("Instance.oldDasPropertiesWrong", propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())));
                port = this.programOpts.getPort();
            }
        }
        dasprops.setProperty("agent.das.protocol", "http");
        dasprops.setProperty("agent.das.port", Integer.toString(port));
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(propfile));
            dasprops.store(bos, "Domain Administration Server Connection Properties");
            bos.close();
            bos = null;
        }
        catch (IOException ex2) {
            logger.printMessage(Strings.get("Instance.dasPropertiesUpdateFailed"));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException cex) {}
            }
        }
        logger.printDebugMessage("New DAS port number: " + port);
        return port;
    }

    private File getTheOneAndOnlyNode(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files.length > 1) {
            throw new CommandException(Strings.get("tooManyNodes", parent));
        }
        if (files.length == 1) {
            return files[0];
        }
        try {
            File f;
            String hostname;
            String dashost = null;
            if (this.programOpts != null) {
                dashost = this.programOpts.getHost();
            }
            if ((hostname = InetAddress.getLocalHost().getHostName()).equals(dashost) || "localhost".equals(dashost) || NetUtils.IsThisHostLocal((String)dashost)) {
                hostname = "localhost";
            }
            if (!(f = new File(parent, hostname)).mkdirs() || !f.isDirectory()) {
                throw new CommandException(Strings.get("cantCreateNodeDirChild", f));
            }
            return f;
        }
        catch (UnknownHostException ex) {
            throw new CommandException(Strings.get("cantGetHostName", ex));
        }
    }

    private File getTheOneAndOnlyInstance(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandException(Strings.get("Instance.noInstanceDirs", parent));
        }
        if (files.length > 2) {
            throw new CommandException(Strings.get("Instance.tooManyInstanceDirs", parent));
        }
        for (File f : files) {
            if (f.getName().equals("agent")) continue;
            return f;
        }
        throw new CommandException(Strings.get("Instance.noInstanceDirs", parent));
    }

    private String getNodeDirRootDefault() throws CommandException {
        String nodeDirDefault = this.getSystemProperty("com.sun.aas.agentRoot");
        if (StringUtils.ok((String)nodeDirDefault)) {
            return nodeDirDefault;
        }
        String installRootPath = this.getInstallRootPath();
        return installRootPath + "/" + "nodeagents";
    }
}

